/*
 * Decompiled with CFR 0.152.
 */
package com.montnets.mwgate.common;

import com.montnets.mwgate.common.StaticValue;
import com.montnets.mwgate.smsutil.ConfigManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class Logger {
    private static String newline = System.getProperties().getProperty("line.separator");
    public static final int LEVEL_OFF = Integer.MAX_VALUE;
    public static final int LEVEL_FATAL = 163835;
    public static final int LEVEL_ERROR = 131068;
    public static final int LEVEL_WARN = 98301;
    public static final int LEVEL_INFO = 65534;
    public static final int LEVEL_DEBUG = Short.MAX_VALUE;
    public static final int LEVEL_ALL = 0;
    private static Logger instance = null;
    private StringBuffer buf = new StringBuffer();
    private String savePath = "";
    private int bufferSize = 0;
    private int printFilterLevel = 0;
    private int saveFilterLevel = 0;
    private static SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public static Logger getSingleton() {
        if (instance == null) {
            instance = new Logger();
        }
        return instance;
    }

    public void info(String message) {
        try {
            if (ConfigManager.NEED_LOG == StaticValue.STATIC_NEED_LOG) {
                this.log(message, 65534);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void error(Exception e, String message) {
        try {
            if (ConfigManager.NEED_LOG == StaticValue.STATIC_NEED_LOG) {
                StringWriter writer = new StringWriter();
                e.printStackTrace(new PrintWriter(writer));
                String logInfo = String.valueOf(message) + newline + ((Object)writer).toString();
                this.log(logInfo, 65534);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void warn(String message) {
        this.log(message, 98301);
    }

    public void error(String message) {
        this.log(message, 131068);
    }

    public void debug(String message) {
        this.log(message, Short.MAX_VALUE);
    }

    public void log(String message, int level) {
        Date nowDate = new Date();
        String time = simpleFormat.format(nowDate);
        if (level >= this.saveFilterLevel) {
            this.buf.append(time).append(" ");
            this.buf.append(message);
            this.buf.append("\r\n");
            this.saveLog();
            this.buf = new StringBuffer(this.bufferSize);
        }
    }

    public void init(String savePath, int bufferSize) {
        this.savePath = savePath;
        this.bufferSize = bufferSize;
        if (!savePath.endsWith("/") && !savePath.endsWith("\\")) {
            savePath = String.valueOf(savePath) + "/";
        }
        this.buf = new StringBuffer(bufferSize);
    }

    public void setPrintFilter(int filterLevel) {
        this.printFilterLevel = filterLevel;
    }

    public void setSaveFilter(int filterLevel) {
        this.saveFilterLevel = filterLevel;
    }

    public static void appendMethodB(String fileName, String content) {
        try {
            FileWriter writer = new FileWriter(fileName, true);
            writer.write(content);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void appendMethodA(String fileName, String content) {
        try {
            RandomAccessFile randomFile = new RandomAccessFile(fileName, "rw");
            long fileLength = randomFile.length();
            randomFile.seek(fileLength);
            randomFile.writeBytes(content);
            randomFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveLog() {
        String fname = String.valueOf(new SimpleDateFormat("yyyyMMdd").format(Calendar.getInstance().getTime())) + ".txt";
        String dayPath = String.valueOf(new SimpleDateFormat("yyyy").format(Calendar.getInstance().getTime())) + "/" + new SimpleDateFormat("MM").format(Calendar.getInstance().getTime());
        try {
            new File(String.valueOf(this.savePath) + dayPath).mkdirs();
            File file = new File(String.valueOf(this.savePath) + dayPath + "/" + fname);
            if (!file.exists()) {
                file.createNewFile();
            }
            Logger.appendMethodB(file.getAbsolutePath(), this.buf.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Logger() {
    }

    public static void main(String[] args) {
        Logger.getSingleton().init("./Logger/", 2024);
        int i = 0;
        while (i < 1000) {
            Logger.getSingleton().warn("hello" + i);
            ++i;
        }
    }
}

