/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.customwords;

import com.google.common.collect.ImmutableList;
import com.mayabot.nlp.collection.dat.DoubleArrayTrieStringIntMap;
import com.mayabot.nlp.segment.WordpathProcessor;
import com.mayabot.nlp.segment.common.BaseSegmentComponent;
import com.mayabot.nlp.segment.plugins.customwords.CustomDictionary;
import com.mayabot.nlp.segment.wordnet.Wordnet;
import com.mayabot.nlp.segment.wordnet.Wordpath;

public class CustomDictionaryProcessor
extends BaseSegmentComponent
implements WordpathProcessor {
    private CustomDictionary dictionary;

    public CustomDictionaryProcessor(CustomDictionary dictionary) {
        super(-500);
        this.dictionary = dictionary;
    }

    @Override
    public Wordpath process(Wordpath wordPath) {
        DoubleArrayTrieStringIntMap dat = this.dictionary.getTrie();
        if (dat == null) {
            return wordPath;
        }
        Wordnet wordnet = wordPath.getWordnet();
        char[] text = wordnet.getCharArray();
        for (DoubleArrayTrieStringIntMap d : ImmutableList.of((Object)dat)) {
            if (d == null) continue;
            DoubleArrayTrieStringIntMap.DATMapMatcherInt datSearch = d.match(text, 0);
            while (datSearch.next()) {
                int length;
                int offset = datSearch.getBegin();
                boolean willCutOtherWords = wordPath.willCutOtherWords(offset, length = datSearch.getLength());
                if (willCutOtherWords || wordnet.getVertex(offset, length) != null) continue;
                wordPath.combine(offset, length);
            }
        }
        return wordPath;
    }

    public CustomDictionary getDictionary() {
        return this.dictionary;
    }

    public CustomDictionaryProcessor setDictionary(CustomDictionary dictionary) {
        this.dictionary = dictionary;
        return this;
    }
}

