/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.lexer.core;

import com.google.common.collect.Lists;
import com.mayabot.nlp.segment.Nature;
import java.util.List;

public final class DictionaryAbsWords {
    public static final int MaxId = 9;
    public static final int BEGIN_ID = 0;
    public static final int END_ID = 1;
    public static final int MQ_ID = 2;
    public static final int NX_ID = 3;
    public static final int TIME_ID = 4;
    public static final int X_ID = 5;
    public static final int NT_ID = 6;
    public static final int NS_ID = 7;
    public static final int NR_ID = 8;
    public static final int M_ID = 9;
    public static final String BEGIN_TAG = "\u00010Begin";
    public static final String END_TAG = "\u00011End";
    public static final String MQ_TAG = "\u00012MQ";
    public static final String NX_TAG = "\u00013NX";
    public static final String TIME_TAG = "\u00014Time";
    public static final String X_TAG = "\u00015String";
    public static final String NT_TAG = "\u00016NT\u56e2\u4f53";
    public static final String NS_TAG = "\u00017NS\u5730\u540d";
    public static final String NR_TAG = "\u00018NR\u4eba\u540d";
    public static final String M_TAG = "\u00019Num";

    public static void main(String[] args) {
        System.out.println(DictionaryAbsWords.allLabel());
    }

    public static int nature2id(Nature nature) {
        switch (nature) {
            case begin: {
                return 0;
            }
            case end: {
                return 1;
            }
            case mq: {
                return 2;
            }
            case nx: {
                return 3;
            }
            case t: {
                return 4;
            }
            case x: {
                return 5;
            }
            case nt: {
                return 6;
            }
            case ns: {
                return 7;
            }
            case nr: {
                return 8;
            }
            case m: {
                return 9;
            }
        }
        return -1;
    }

    public static String id2label(int id) {
        switch (id) {
            case 0: {
                return BEGIN_TAG;
            }
            case 1: {
                return END_TAG;
            }
            case 2: {
                return MQ_TAG;
            }
            case 3: {
                return NX_TAG;
            }
            case 4: {
                return TIME_TAG;
            }
            case 5: {
                return X_TAG;
            }
            case 6: {
                return NT_TAG;
            }
            case 7: {
                return NS_TAG;
            }
            case 8: {
                return NR_TAG;
            }
            case 9: {
                return M_TAG;
            }
        }
        return null;
    }

    public static List<String> allLabel() {
        return Lists.newArrayList((Object[])new String[]{BEGIN_TAG, END_TAG, MQ_TAG, NX_TAG, TIME_TAG, X_TAG, NT_TAG, NS_TAG, NR_TAG, M_TAG});
    }
}

