/*
 * Decompiled with CFR 0.152.
 */
package com.manon.member.util;

import cn.hutool.core.util.StrUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class HttpUtil {
    public static void getOutPut(String obj, HttpServletResponse response) throws IOException {
        PrintWriter out = response.getWriter();
        out.print(obj);
    }

    public static String getIpAddr(HttpServletRequest request) {
        String[] strIps;
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (StrUtil.isNotEmpty((CharSequence)ip) && !"unknown".equalsIgnoreCase(ip) && (strIps = StrUtil.str((CharSequence)ip).split(",")) != null && strIps.length > 1) {
            return StrUtil.str((CharSequence)strIps[1]);
        }
        return ip;
    }

    public static Integer getBrowingType(HttpServletRequest request) {
        String agent = request.getHeader("USER-AGENT");
        if (null != agent && -1 != agent.indexOf("MSIE")) {
            return 1;
        }
        if (null != agent && -1 != agent.indexOf("Firefox")) {
            return 2;
        }
        if (null != agent && -1 != agent.indexOf("Safari")) {
            return 3;
        }
        return 4;
    }

    public static String getDomain(HttpServletRequest request) {
        String domain = null;
        String domainreferer = request.getHeader("referer");
        if (domainreferer != null) {
            String replaceReferer = domainreferer.replace("http://", "");
            domain = domainreferer != null && replaceReferer.indexOf("/") > 0 ? replaceReferer.substring(0, replaceReferer.indexOf("/")) : replaceReferer.substring(0, replaceReferer.length());
        }
        return domain;
    }

    public static boolean isTrackIntercepter(HttpServletRequest request) {
        String domainreferer = request.getHeader("referer");
        String remoteIp = HttpUtil.getIpAddr(request);
        String serviceIp = request.getLocalAddr();
        boolean iptrueOrfalse = false;
        String domain = null;
        if (domainreferer != null) {
            String replaceReferer = domainreferer.replace("http://", "");
            domain = domainreferer != null && replaceReferer.indexOf("/") != -1 ? replaceReferer.substring(0, replaceReferer.indexOf("/")) : replaceReferer;
            if (domain != null && !domain.startsWith("www.yougou.com")) {
                iptrueOrfalse = true;
            }
        } else if (!remoteIp.equals(serviceIp)) {
            iptrueOrfalse = true;
        }
        return iptrueOrfalse;
    }

    public static String getServiceRoot(HttpServletRequest request) {
        String url = request.getRequestURL().toString();
        return url.substring(0, url.lastIndexOf(47));
    }

    public static String getEncoding(String encondingName) throws UnsupportedEncodingException {
        return URLEncoder.encode(URLEncoder.encode(encondingName, "UTF-8"), "UTF-8");
    }

    public static String getUrl(HttpServletRequest request) {
        StringBuilder urlBuilder = new StringBuilder();
        try {
            urlBuilder.append(HttpUtil.getRootPath(request, false));
            if (StrUtil.isNotBlank((CharSequence)request.getQueryString())) {
                String query = "?" + new String(request.getQueryString().trim().getBytes("ISO-8859-1"));
                urlBuilder.append(query);
            }
            return URLEncoder.encode(urlBuilder.toString(), "UTF-8");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getRootPath(HttpServletRequest request, boolean includePort) {
        String context;
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(request.getScheme());
        urlBuilder.append("://");
        urlBuilder.append(request.getServerName());
        if (includePort) {
            urlBuilder.append(":");
            urlBuilder.append(request.getServerPort());
        }
        if (StrUtil.isBlank((CharSequence)(context = request.getContextPath()))) {
            context = HttpUtil.getOriginalUri(request);
        }
        urlBuilder.append(context);
        return urlBuilder.toString();
    }

    public static String getOriginalUri(HttpServletRequest request) {
        return request.getAttribute("javax.servlet.forward.request_uri").toString();
    }
}

