/*
 * Decompiled with CFR 0.152.
 */
package com.manon.member.error;

import cn.hutool.core.util.StrUtil;
import com.manon.member.error.GlobalExceptionHandler;
import com.manon.member.exception.DAOException;
import com.manon.member.exception.ErrorException;
import com.manon.member.exception.ParamsException;
import com.manon.member.exception.ServiceException;
import com.manon.member.http.ErrorResponse;
import com.manon.member.http.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class DefaultGlobalExceptionHandler
implements GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultGlobalExceptionHandler.class);

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Response jsonExceptionHandler(ServiceException e) {
        log.info("catch service exception", (Object)e.getMessage(), (Object)e);
        return Response.fail(e.code, e.getErrorCode(), StrUtil.isNotEmpty((CharSequence)e.getErrorMsg()) ? e.getErrorMsg() : e.getMessage(), null);
    }

    @ExceptionHandler(value={ParamsException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Response jsonParamsExceptionHandler(ParamsException e) {
        log.info("catch params exception", (Object)e.getMessage(), (Object)e);
        return Response.fail(e.code, e.getErrorCode(), StrUtil.isNotEmpty((CharSequence)e.getErrorMsg()) ? e.getErrorMsg() : e.getMessage(), null);
    }

    @ExceptionHandler(value={ErrorException.class, DAOException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ErrorResponse jsonExceptionHandler(ErrorException e) {
        log.error("catch exception", (Object)e.getMessage(), (Object)e);
        return ErrorResponse.fail(2, e.getErrorCode(), e.getMessage());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ErrorResponse jsonValidExceptionHandler(MethodArgumentNotValidException e) {
        FieldError fieldError = e.getBindingResult().getFieldError();
        log.info("catch exception", (Object)(fieldError.getField() + ":" + fieldError.getDefaultMessage()), (Object)e);
        return ErrorResponse.fail(6, 60001, fieldError.getDefaultMessage(), null);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ErrorResponse jsonExceptionHandler(Exception e) {
        log.error("catch exception", (Object)e.getMessage(), (Object)e);
        return ErrorResponse.fail(2, (Integer)50001, "\u670d\u52a1\u7aef\u5f02\u5e38,\u8bf7\u7a0d\u540e\u518d\u8bd5");
    }
}

