/*
 * Decompiled with CFR 0.152.
 */
package com.manon.member.controller;

import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.TypeUtil;
import com.google.common.collect.Maps;
import com.manon.member.dto.DTO;
import com.manon.member.page.Page;
import com.manon.member.page.PageRequest;
import com.manon.member.service.CrudService;
import com.manon.member.util.BaseFiledUtil;
import com.manon.member.util.BeanConvertUtil;
import com.manon.member.vo.VO;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

public abstract class AbstractBaseController<V extends VO, D extends DTO> {
    @Autowired
    CrudService<D> crudService;

    protected String defaultSortColumns() {
        String createTime = StrUtil.toUnderlineCase((CharSequence)BaseFiledUtil.CREATE_TIME_FLAG);
        return createTime.concat(" desc");
    }

    protected Map<String, Object> generateMap(D dto) {
        Map map = Maps.newHashMap();
        if (dto != null && dto.getMap() != null) {
            map = dto.getMap();
        }
        return map;
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u4fe1\u606f", notes="\u67e5\u8be2\u6570\u636e\u5e93\u4e2d\u67d0\u4e2a\u7684\u4fe1\u606f")
    protected V getById(@PathVariable(value="id") String id) {
        DTO dto = this.crudService.getById(id);
        VO o = (VO)BeanConvertUtil.convertBean((Object)dto, (Class)this.getClassVo());
        return (V)o;
    }

    @GetMapping
    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u4fe1\u606f", notes="\u67e5\u8be2\u4e00\u4e2aList")
    protected List<V> query(D dto, HttpServletRequest request) {
        String sortColumns = request.getParameter("sortColumns");
        dto.setOrderByClause(StringUtils.hasText((String)sortColumns) ? sortColumns : this.defaultSortColumns());
        dto.setMap(this.generateMap(dto));
        List ds = this.crudService.list(dto);
        List objects = BeanConvertUtil.convertBeanList((List)ds, (Class)this.getClassVo());
        return objects;
    }

    @GetMapping(value={"/page"})
    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u4fe1\u606f", notes="\u67e5\u8be2\u4e00\u4e2apage")
    protected Page<V> pageQuery(D dto, HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        Integer current = 1;
        Integer pageSize = 10;
        if (parameterMap.containsKey("current") || parameterMap.containsKey("pageSize")) {
            String sc;
            if (parameterMap.containsKey("current")) {
                current = Integer.parseInt(request.getParameter("current"));
            }
            if (parameterMap.containsKey("pageSize") && (pageSize = Integer.valueOf(Integer.parseInt(request.getParameter("pageSize")))) > 9999) {
                pageSize = 10;
            }
            String sortColumns = StringUtils.hasText((String)(sc = request.getParameter("sortColumns"))) ? sc : this.defaultSortColumns();
            dto.setMap(this.generateMap(dto));
            PageRequest pageRequest = PageRequest.build((int)current, (int)pageSize, dto, (String)sortColumns);
            Page pageInfo = this.crudService.pageQuery(pageRequest);
            Page page = BeanConvertUtil.convertPage((Page)pageInfo, (Class)this.getClassVo());
            return page;
        }
        return null;
    }

    @PostMapping
    @ApiOperation(value="\u63d0\u4ea4\u4fe1\u606f", notes="\u63d0\u4ea4")
    protected V insert(@RequestBody @Validated D dto) {
        Map<String, Object> map = this.generateMap(dto);
        dto.setMap(map);
        dto = this.crudService.insert(dto);
        VO o = (VO)BeanConvertUtil.convertBean(dto, (Class)this.getClassVo());
        return (V)o;
    }

    @PutMapping(value={"/{id}"})
    @ApiOperation(value="\u4fee\u6539", notes="\u4fee\u6539")
    protected V update(@PathVariable(value="id") String id, @RequestBody D dto) {
        dto.setMap(this.generateMap(dto));
        DTO d = this.crudService.update(id, dto);
        VO o = (VO)BeanConvertUtil.convertBean((Object)d, (Class)this.getClassVo());
        return (V)o;
    }

    @PatchMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eID\u4fee\u6539", notes="\u6839\u636eID\u4fee\u6539")
    protected V updateSelective(@PathVariable(value="id") String id, @RequestBody D dto) {
        dto.setMap(this.generateMap(dto));
        DTO d = this.crudService.updateSelective(id, dto);
        VO o = (VO)BeanConvertUtil.convertBean((Object)d, (Class)this.getClassVo());
        return (V)o;
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eID\u5220\u9664\u67d0\u4e2a\u4fe1\u606f", notes="\u6839\u636eID\u5220\u9664\u67d0\u4e2a\u4fe1\u606f")
    protected boolean delete(@PathVariable(value="id") String id) {
        return this.crudService.delete(id);
    }

    private Class getClassVo() {
        Class clz = TypeUtil.getClass((Type)TypeUtil.getTypeArgument(this.getClass(), (int)0));
        return clz;
    }
}

