/*
 * Decompiled with CFR 0.152.
 */
package com.manon.member.actuate;

import cn.hutool.core.collection.CollUtil;
import com.google.common.collect.Lists;
import com.manon.member.actuate.dto.MappingInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestMethodsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@RestControllerEndpoint(id="member")
public class MappingsControllerEndpoint {
    @RequestMapping(value={"/mappings"})
    public List<MappingInfo> getMappings(HttpServletRequest request) {
        ArrayList uList = Lists.newArrayList();
        WebApplicationContext wac = (WebApplicationContext)request.getAttribute(DispatcherServlet.WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        Map requestMappings = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)wac, HandlerMapping.class, (boolean)true, (boolean)false);
        for (HandlerMapping handlerMapping : requestMappings.values()) {
            if (!(handlerMapping instanceof RequestMappingHandlerMapping)) continue;
            RequestMappingHandlerMapping rmhm = (RequestMappingHandlerMapping)handlerMapping;
            Map handlerMethods = rmhm.getHandlerMethods();
            for (RequestMappingInfo rmi : handlerMethods.keySet()) {
                MappingInfo mappingInfo = new MappingInfo();
                PatternsRequestCondition prc = rmi.getPatternsCondition();
                Set patterns = prc.getPatterns();
                RequestMethodsRequestCondition rmrc = rmi.getMethodsCondition();
                Set methods = rmrc.getMethods();
                mappingInfo.setMapping((String)CollUtil.getFirst((Iterable)patterns));
                if (CollUtil.isNotEmpty((Collection)methods)) {
                    mappingInfo.setMethod(((RequestMethod)CollUtil.getFirst((Iterable)methods)).name());
                }
                uList.add(mappingInfo);
            }
        }
        return uList;
    }
}

