/*
 * Decompiled with CFR 0.152.
 */
package com.manon.member.cdp.util;

import cn.hutool.core.convert.Convert;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.manon.member.cdp.error.AppErr;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final Logger log = LoggerFactory.getLogger(JsonUtil.class);

    public static String getItemValue(JSONObject jsonObject, String keyName) {
        return JsonUtil.getItemValue(jsonObject, keyName, null);
    }

    public static String getItemValue(JSONObject jsonObject, String keyName, String defaultValue) {
        return JsonUtil.getItemValue(jsonObject, keyName, defaultValue, false);
    }

    public static String getItemValue(JSONObject jsonObject, String keyName, String defaultValue, boolean isThrow) {
        Object item = JsonUtil.getItem(jsonObject, keyName, defaultValue, isThrow);
        if (item == null) {
            return null;
        }
        return item.toString();
    }

    public static Integer getItemIntegerValue(JSONObject jsonObject, String keyName) {
        return JsonUtil.getItemIntegerValue(jsonObject, keyName, -1);
    }

    public static Integer getItemIntegerValue(JSONObject jsonObject, String keyName, Integer defaultValue) {
        return JsonUtil.getItemIntegerValue(jsonObject, keyName, defaultValue, false);
    }

    public static Integer getItemIntegerValue(JSONObject jsonObject, String keyName, Integer defaultValue, boolean isThrow) {
        return Integer.parseInt(JsonUtil.getItem(jsonObject, keyName, defaultValue, isThrow).toString());
    }

    public static Double getItemDoubleValue(JSONObject jsonObject, String keyName) {
        return JsonUtil.getItemDoubleValue(jsonObject, keyName, -1.0);
    }

    public static Double getItemDoubleValue(JSONObject jsonObject, String keyName, Double defaultValue) {
        return JsonUtil.getItemDoubleValue(jsonObject, keyName, defaultValue, false);
    }

    public static Double getItemDoubleValue(JSONObject jsonObject, String keyName, Double defaultValue, boolean isThrow) {
        return Double.parseDouble(JsonUtil.getItem(jsonObject, keyName, defaultValue, isThrow).toString());
    }

    public static Long getItemLongValue(JSONObject jsonObject, String keyName) {
        return JsonUtil.getItemLongValue(jsonObject, keyName, -1L);
    }

    public static Long getItemLongValue(JSONObject jsonObject, String keyName, Long defaultValue) {
        return JsonUtil.getItemLongValue(jsonObject, keyName, defaultValue, false);
    }

    public static Long getItemLongValue(JSONObject jsonObject, String keyName, Long defaultValue, boolean isThrow) {
        return Long.parseLong(JsonUtil.getItem(jsonObject, keyName, defaultValue, isThrow).toString());
    }

    public static Date getItemDateValue(JSONObject jsonObject, String keyName) {
        return JsonUtil.getItemDateValue(jsonObject, keyName, null);
    }

    public static Date getItemDateValue(JSONObject jsonObject, String keyName, Date defaultValue) {
        return JsonUtil.getItemDateValue(jsonObject, keyName, defaultValue, false);
    }

    public static Date getItemDateValue(JSONObject jsonObject, String keyName, Date defaultValue, boolean isThrow) {
        Object item = JsonUtil.getItem(jsonObject, keyName, defaultValue, isThrow);
        if (item == null) {
            return null;
        }
        return Convert.toDate((Object)item);
    }

    public static JSONObject getItemJsonObject(JSONObject jsonObject, String keyName) {
        return JsonUtil.getItemJsonObject(jsonObject, keyName, new JSONObject());
    }

    public static JSONObject getItemJsonObject(JSONObject jsonObject, String keyName, JSONObject defaultValue) {
        return JsonUtil.getItemJsonObject(jsonObject, keyName, defaultValue, false);
    }

    public static JSONObject getItemJsonObject(JSONObject jsonObject, String keyName, JSONObject defaultValue, boolean isThrow) {
        Object object = JsonUtil.getItem(jsonObject, keyName, defaultValue, isThrow);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        return new JSONObject(object);
    }

    public static JSONArray getItemJsonArray(JSONObject jsonObject, String keyName) {
        return JsonUtil.getItemJsonArray(jsonObject, keyName, new JSONArray());
    }

    public static JSONArray getItemJsonArray(JSONObject jsonObject, String keyName, JSONArray defaultValue) {
        return JsonUtil.getItemJsonArray(jsonObject, keyName, defaultValue, false);
    }

    public static JSONArray getItemJsonArray(JSONObject jsonObject, String keyName, JSONArray defaultValue, boolean isThrow) {
        Object object = JsonUtil.getItem(jsonObject, keyName, defaultValue, isThrow);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        return new JSONArray(object);
    }

    private static Object getItem(JSONObject jsonObject, String keyName, Object defaultValue, boolean isThrow) {
        if (jsonObject == null || jsonObject.keySet().size() <= 0) {
            if (isThrow) {
                throw AppErr.System.PARAMETER_FORMAT_ERR.exception("jsonObject\u4e3a\u7a7a");
            }
            return defaultValue;
        }
        if (jsonObject.containsKey((Object)keyName)) {
            if (jsonObject.get((Object)keyName) == null) {
                if (isThrow) {
                    throw AppErr.System.SERVICE_ERR.exception("======key\u4e3a" + keyName + "\u7684value\u503c\u4e3a\u7a7a,\u8fd4\u56de\u9ed8\u8ba4\u503c======");
                }
                return defaultValue;
            }
            return jsonObject.get((Object)keyName);
        }
        return defaultValue;
    }
}

