/*
 * Decompiled with CFR 0.152.
 */
package com.manon.member.cdp.syncdata;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.manon.member.cdp.util.Snow;
import com.manon.member.db.adb.AdbEngine;
import com.manon.member.db.adb.AdbJsonBaseDataManager;
import com.manon.member.db.core.MetaManager;
import com.manon.member.db.core.MetaModel;
import com.manon.member.db.mysql.MysqlEngine;
import com.manon.member.db.mysql.MysqlJsonBaseDataManager;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class AnalysisData {
    private static final int SNOW_NODE = 1;
    private static final String VALUE_SOURCE_GET_FOREIGN_KEY = "get_foreign_key";
    private static final String VALUE_SOURCE_GET_AUTO_ID = "get_auto_id";
    private static final String ID = "id";
    private static final String OPERATE_INSERT = "insert";
    private static final String OPERATE_UPDATE = "update";
    private static final String OPERATE_DELETE = "delete";
    private static final String OBJECT_PATH = "o";
    private static final String ARRAY_PATH = "a";
    private static final String KEY_PATH = "key";
    private static final String ABD = "adb";
    private static final String MYSQL = "mysql";

    public static void execute(String interfaceCode, Object object) throws Exception {
        String queryMetaInterFaceDefSql = "SELECT * FROM meta_interface_def WHERE interface_code=?";
        MysqlJsonBaseDataManager commonInstance = MysqlEngine.getCommonInstance();
        JSONObject metaInterFaceDefObj = commonInstance.executeQueryForObject(queryMetaInterFaceDefSql, new Object[]{interfaceCode});
        String id = metaInterFaceDefObj.getStr((Object)ID);
        String queryMetaInterfaceDbMappingSql = "SELECT * FROM meta_interface_db_mapping WHERE meta_interface_def_id=?";
        JSONArray metaInterfaceDbMappingArr = commonInstance.executeQuery(queryMetaInterfaceDbMappingSql, new Object[]{id});
        String opPath = metaInterFaceDefObj.getStr((Object)"op_path");
        String operate = OPERATE_INSERT;
        if (StringUtils.isNotEmpty((CharSequence)opPath)) {
            String opPathComment = metaInterFaceDefObj.getStr((Object)"op_path_comment");
            String[] paths = opPath.split("\\.");
            String[] comments = opPathComment.split("\\.");
            JSONObject jsonObject = JSONUtil.parseObj((String)JSONUtil.toJsonStr((Object)object));
            for (int i = 1; i < paths.length; ++i) {
                if (!StringUtils.equals((CharSequence)OBJECT_PATH, (CharSequence)comments[i])) {
                    if (StringUtils.equals((CharSequence)ARRAY_PATH, (CharSequence)comments[i])) {
                        throw new Exception(String.format("\u64cd\u4f5c\u7c7b\u578b\u8def\u5f84\u4e0d\u80fd\u5305\u62ecARRAY,interface_code=%s", interfaceCode));
                    }
                    if (StringUtils.equals((CharSequence)KEY_PATH, (CharSequence)comments[i])) {
                        operate = jsonObject.getStr((Object)paths[i]);
                        break;
                    }
                    throw new Exception(String.format("\u64cd\u4f5c\u7c7b\u578b\u8def\u5f84\u91ca\u4e49\u4e0d\u5408\u6cd5,interface_code=%s", interfaceCode));
                }
                jsonObject = jsonObject.getJSONObject((Object)paths[i]);
            }
        }
        AnalysisData.analysisObject(object, null, metaInterfaceDbMappingArr, null, operate);
    }

    private static void analysisObject(Object object, StringBuilder path, JSONArray metaInterfaceDbMappingArr, String parentId, String operate) {
        if (object instanceof JSONObject) {
            if (StringUtils.isEmpty((CharSequence)path)) {
                path = new StringBuilder(OBJECT_PATH);
            }
            AnalysisData.analysisJsonObject((JSONObject)object, path, metaInterfaceDbMappingArr, parentId, operate);
        } else if (object instanceof JSONArray) {
            JSONArray array = (JSONArray)object;
            for (Object o : array) {
                if (StringUtils.isEmpty((CharSequence)path)) {
                    path = new StringBuilder(ARRAY_PATH);
                }
                AnalysisData.analysisObject(o, path, metaInterfaceDbMappingArr, parentId, operate);
            }
        }
    }

    private static void analysisJsonObject(JSONObject jsonObject, StringBuilder finalPath, JSONArray metaInterfaceDbMappingArr, String parentId, String operate) {
        String dbName;
        String dbType;
        Object object;
        JSONObject tableObj = new JSONObject();
        JSONArray childMetaInterfaceDbMappingArr = AnalysisData.getAllPath(metaInterfaceDbMappingArr, new String(finalPath));
        for (Object o : childMetaInterfaceDbMappingArr) {
            Object value;
            object = (JSONObject)o;
            dbType = object.getStr((Object)"db_type");
            dbName = object.getStr((Object)"db_name");
            String tableName = object.getStr((Object)"table_name");
            String fieldName = object.getStr((Object)"field_name");
            String valueSource = object.getStr((Object)"value_source");
            if (StringUtils.equals((CharSequence)VALUE_SOURCE_GET_FOREIGN_KEY, (CharSequence)valueSource)) {
                value = parentId;
            } else if (StringUtils.equals((CharSequence)VALUE_SOURCE_GET_AUTO_ID, (CharSequence)valueSource)) {
                Snow snow = new Snow(1);
                value = String.valueOf(snow.next());
            } else {
                value = jsonObject.get((Object)valueSource);
            }
            if (tableObj.containsKey((Object)tableName)) {
                JSONObject data = tableObj.getJSONObject((Object)tableName).getJSONObject((Object)"data");
                data.put(fieldName, value);
                continue;
            }
            JSONObject tableNameObj = new JSONObject();
            tableNameObj.put("dbType", (Object)dbType);
            tableNameObj.put("dbName", (Object)dbName);
            JSONObject data = new JSONObject();
            data.put(fieldName, value);
            tableNameObj.put("data", (Object)data);
            tableObj.put(tableName, (Object)tableNameObj);
        }
        for (String tableName : tableObj.keySet()) {
            JSONObject tableNameObj = tableObj.getJSONObject((Object)tableName);
            dbType = tableNameObj.getStr((Object)"dbType");
            dbName = tableNameObj.getStr((Object)"dbName");
            JSONObject data = tableNameObj.getJSONObject((Object)"data");
            AnalysisData.operateObj(dbType, dbName, tableName, data, operate);
        }
        for (String key : jsonObject.keySet()) {
            object = jsonObject.get((Object)key);
            if (!(object instanceof JSONObject) && !(object instanceof JSONArray)) continue;
            StringBuilder path = new StringBuilder(finalPath);
            path.append(".").append(key);
            JSONArray array = AnalysisData.getAllPath(metaInterfaceDbMappingArr, new String(path));
            String id = null;
            for (Object o : array) {
                JSONObject obj = (JSONObject)o;
                String valueSource = obj.getStr((Object)"value_source");
                String tableNameParent = obj.getStr((Object)"table_name_parent");
                if (!StringUtils.equals((CharSequence)VALUE_SOURCE_GET_FOREIGN_KEY, (CharSequence)valueSource)) continue;
                MetaManager metaManager = new MetaManager();
                MetaModel metaModel = metaManager.getMetaData(tableNameParent);
                List phyKeys = metaModel.getPhyKeys();
                id = tableObj.getJSONObject((Object)tableNameParent).getJSONObject((Object)"data").getStr(phyKeys.get(0));
                break;
            }
            AnalysisData.analysisObject(object, new StringBuilder(path), metaInterfaceDbMappingArr, id, operate);
        }
    }

    private static JSONArray getAllPath(JSONArray metaInterfaceDbMappingArr, String path) {
        return metaInterfaceDbMappingArr.stream().filter(o -> {
            JSONObject object = (JSONObject)o;
            String mappingPath = object.getStr((Object)"mapping_path");
            return StringUtils.equals((CharSequence)mappingPath, (CharSequence)path);
        }).collect(Collectors.toCollection(JSONArray::new));
    }

    private static void operateObj(String dbType, String dbName, String tableName, JSONObject object, String operate) {
        if (StringUtils.equals((CharSequence)dbType, (CharSequence)ABD)) {
            AdbJsonBaseDataManager adbInstance = AdbEngine.getAdbInstance();
            switch (operate) {
                case "insert": {
                    int insert = adbInstance.insert(tableName, object, null);
                    break;
                }
            }
        } else if (StringUtils.equals((CharSequence)dbType, (CharSequence)MYSQL)) {
            // empty if block
        }
    }
}

