/*
 * Decompiled with CFR 0.152.
 */
package com.manon.member.cdp.exception;

import cn.hutool.core.util.StrUtil;
import com.manon.member.cdp.error.AppErr;
import com.manon.member.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdpServiceException
extends ServiceException {
    private static final Logger log = LoggerFactory.getLogger(CdpServiceException.class);
    private static final long serialVersionUID = -9195839961888070076L;

    public CdpServiceException(AppErr errorCode, String errorMsg, Throwable throwable) {
        this.setErrorInfo(errorCode, errorMsg, throwable);
    }

    public CdpServiceException(AppErr errorCode, Throwable throwable) {
        this.setErrorInfo(errorCode, null, throwable);
    }

    private void setErrorInfo(AppErr errorCode, String errorMsg, Throwable throwable) {
        Integer errorCodePrefix = -1;
        switch (errorCode.getErrorSource()) {
            case LABEL_CENTER: {
                errorCodePrefix = 50100;
                break;
            }
            case MARKETING_CENTER: {
                errorCodePrefix = 50200;
                break;
            }
            case DISPATCH_CENTER: {
                errorCodePrefix = 50300;
                break;
            }
            default: {
                errorCodePrefix = 50500;
            }
        }
        this.errorCode = errorCodePrefix + errorCode.getErrorCode();
        this.errorMsg = StrUtil.isEmpty((CharSequence)errorMsg) && throwable != null ? throwable.getMessage() : errorMsg;
        log.error("========================================> errorSource:[{}] errorCode:[{}] errorCodeRemark:[{}] errorMsg:[{}]", new Object[]{errorCode.getErrorSource(), this.errorCode, errorCode.getErrorRemark(), this.errorMsg, throwable});
    }
}

