/*
 * Decompiled with CFR 0.152.
 */
package com.manon.member.cdp.exception;

import cn.hutool.core.util.StrUtil;
import com.manon.member.cdp.error.AppErr;
import com.manon.member.exception.ParamsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdpParamsException
extends ParamsException {
    private static final Logger log = LoggerFactory.getLogger(CdpParamsException.class);
    private static final long serialVersionUID = -530253915531396282L;

    public CdpParamsException(AppErr errorCode, String errorMsg, Throwable throwable) {
        this.setErrorInfo(errorCode, errorMsg, throwable);
    }

    public CdpParamsException(AppErr errorCode, Throwable throwable) {
        this.setErrorInfo(errorCode, null, throwable);
    }

    private void setErrorInfo(AppErr errorCode, String errorMsg, Throwable throwable) {
        Integer errorCodePrefix = -1;
        switch (errorCode.getErrorSource()) {
            case LABEL_CENTER: {
                errorCodePrefix = 60100;
                break;
            }
            case MARKETING_CENTER: {
                errorCodePrefix = 60200;
                break;
            }
            case DISPATCH_CENTER: {
                errorCodePrefix = 60300;
                break;
            }
            default: {
                errorCodePrefix = 60500;
            }
        }
        this.errorCode = errorCodePrefix + errorCode.getErrorCode();
        this.errorMsg = StrUtil.isEmpty((CharSequence)errorMsg) && throwable != null ? throwable.getMessage() : errorMsg;
        log.error("errorSource:[{}] errorCode:[{}] errorMsg:[{}]", new Object[]{errorCode.getErrorSource(), this.errorCode, this.errorMsg, throwable});
    }
}

