/*
 * Decompiled with CFR 0.152.
 */
package com.manon.member.cdp.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.json.JSONUtil;
import com.manon.member.excel.ExcelUtil;
import com.manon.member.excel.annotation.Excel;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdpExcelUtil
extends ExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(CdpExcelUtil.class);

    public static Map<String, String> getHeaderAlias(Class c) {
        Field[] fields;
        HashMap headerAlias = CollectionUtil.newHashMap();
        for (Field field : fields = ReflectUtil.getFields((Class)c)) {
            if (!field.isAnnotationPresent(Excel.class)) continue;
            Excel annotation = field.getAnnotation(Excel.class);
            headerAlias.put(annotation.value(), field.getName());
        }
        return headerAlias;
    }

    public static boolean validateHeader(List<Object> headerList, Map<String, String> headerAlias) {
        if (CollectionUtil.isEmpty(headerList)) {
            return false;
        }
        for (Map.Entry<String, String> headerEntry : headerAlias.entrySet()) {
            boolean isExist = false;
            for (Object header : headerList) {
                if (!headerEntry.getKey().equals((String)header)) continue;
                isExist = true;
            }
            if (isExist) continue;
            log.warn("Excel\u89e3\u6790\u5931\u8d25\uff0c\u6807\u9898\u4e0d\u5339\u914d, targetHeader={}, headerList={}", (Object)headerEntry.getKey(), (Object)JSONUtil.toJsonStr(headerList));
            return false;
        }
        return true;
    }
}

