/*
 * Decompiled with CFR 0.152.
 */
package com.manon.member.cdp.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import cn.hutool.poi.excel.ExcelReader;
import com.manon.member.cdp.excel.CdpExcelUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdpExcelReader
extends ExcelReader {
    private static final Logger log = LoggerFactory.getLogger(CdpExcelReader.class);

    public CdpExcelReader(InputStream bookStream, int sheetIndex, boolean closeAfterRead) {
        super(bookStream, sheetIndex, closeAfterRead);
    }

    public CdpExcelReader(InputStream bookStream, String sheetName, boolean closeAfterRead) {
        super(bookStream, sheetName, closeAfterRead);
    }

    public <T> List<T> read(String sheetName, int headerRowIndex, int startRowIndex, Class<T> beanType) {
        super.setSheet(sheetName);
        return this.read(headerRowIndex, startRowIndex, Integer.MAX_VALUE, beanType);
    }

    public <T> List<T> read(Integer sheetIndex, int headerRowIndex, int startRowIndex, Class<T> beanType) {
        super.setSheet(sheetIndex.intValue());
        return this.read(headerRowIndex, startRowIndex, Integer.MAX_VALUE, beanType);
    }

    public <T> List<T> read(int headerRowIndex, int startRowIndex, int endRowIndex, Class<T> beanType) {
        super.setHeaderAlias(null);
        ArrayList beanList = CollectionUtil.newArrayList((Object[])new Object[0]);
        Map<String, String> headerAlias = CdpExcelUtil.getHeaderAlias(beanType);
        if (CollectionUtil.isEmpty(headerAlias)) {
            log.warn("Excel\u89e3\u6790\u5931\u8d25\uff0cExcel\u6807\u9898\u522b\u540dMap\u4e3anull, \u8bf7\u5728Class\u4e0a\u4f9d\u6b21\u5bf9\u6807\u9898\u6620\u5c04\u5b57\u6bb5\u8fdb\u884c@Excel\u6ce8\u89e3\u3002ClassName={}", (Object)beanType.getName());
            return beanList;
        }
        List headerList = (List)super.read(headerRowIndex, headerRowIndex).get(0);
        boolean isValidate = CdpExcelUtil.validateHeader(headerList, headerAlias);
        if (!isValidate) {
            log.warn("Excel\u89e3\u6790\u5931\u8d25\uff0c\u6807\u9898\u4e0d\u5339\u914d, headerAlias={}, headerList={}", (Object)JSONUtil.toJsonStr(headerAlias), (Object)JSONUtil.toJsonStr((Object)headerList));
            return beanList;
        }
        super.setHeaderAlias(headerAlias);
        return super.read(headerRowIndex, startRowIndex, endRowIndex, beanType);
    }
}

