/*
 * Decompiled with CFR 0.152.
 */
package kr.weitao.discovery.service;

import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Component
@RestController
public class DiscoveryService {
    @Autowired
    private DiscoveryClient discoveryClient;

    @RequestMapping(value={"/discovery"})
    public String doDiscoveryService() {
        StringBuilder buf = new StringBuilder();
        List serviceIds = this.discoveryClient.getServices();
        if (!CollectionUtils.isEmpty((Collection)serviceIds)) {
            for (String s : serviceIds) {
                System.out.println("serviceId:" + s);
                List serviceInstances = this.discoveryClient.getInstances(s);
                if (!CollectionUtils.isEmpty((Collection)serviceInstances)) {
                    for (ServiceInstance si : serviceInstances) {
                        buf.append("[" + si.getServiceId() + " host=" + si.getHost() + " port=" + si.getPort() + " uri=" + si.getUri() + "]");
                    }
                    continue;
                }
                buf.append("no service.");
            }
        }
        return buf.toString();
    }
}

