/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.sdk.producer;

public class ProducerConfig {
    private String metaServerAddress = null;
    protected int maxRetryTimes = 2;
    private boolean enableCompress = true;
    private boolean enableMessageTrace = false;
    private boolean showInfoLevelSendMsgLog = true;
    private int remoteCallRetryWaitTime = 100;
    private int maxMsgSize = 262144;
    private int sendTimeout = 0;
    private int refreshRouteRetryWaitTime = 200;

    public int getRemoteCallRetryWaitTime() {
        return this.remoteCallRetryWaitTime;
    }

    public void setRemoteCallRetryWaitTime(int remoteCallRetryWaitTime) {
        this.remoteCallRetryWaitTime = remoteCallRetryWaitTime;
    }

    public int getRefreshRouteRetryWaitTime() {
        return this.refreshRouteRetryWaitTime;
    }

    public void setRefreshRouteRetryWaitTime(int refreshRouteRetryWaitTime) {
        this.refreshRouteRetryWaitTime = refreshRouteRetryWaitTime;
    }

    public int getMaxMsgSize() {
        return this.maxMsgSize;
    }

    public void setMaxMsgSize(int maxMsgSize) {
        this.maxMsgSize = maxMsgSize;
    }

    public int getSendTimeout() {
        return this.sendTimeout;
    }

    public void setSendTimeout(int sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    private ProducerConfig() {
    }

    public String getMetaServerAddress() {
        return this.metaServerAddress;
    }

    public void setMetaServerAddress(String metaServerAddress) {
        this.metaServerAddress = metaServerAddress;
    }

    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    public boolean isEnableCompress() {
        return this.enableCompress;
    }

    public void setEnableCompress(boolean enableCompress) {
        this.enableCompress = enableCompress;
    }

    public boolean isEnableMessageTrace() {
        return this.enableMessageTrace;
    }

    public void setEnableMessageTrace(boolean enableMessageTrace) {
        this.enableMessageTrace = enableMessageTrace;
    }

    public boolean isShowInfoLevelSendMsgLog() {
        return this.showInfoLevelSendMsgLog;
    }

    public void setShowInfoLevelSendMsgLog(boolean showInfoLevelSendMsgLog) {
        this.showInfoLevelSendMsgLog = showInfoLevelSendMsgLog;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "ProducerConfig{metaServerAddress='" + this.metaServerAddress + '\'' + ", maxRetryTimes=" + this.maxRetryTimes + ", enableCompress=" + this.enableCompress + ", enableMessageTrace=" + this.enableMessageTrace + '}';
    }

    public static class Builder {
        private ProducerConfig producerConfig = new ProducerConfig();

        public Builder metaServerAddress(String metaServerAddress) {
            this.producerConfig.setMetaServerAddress(metaServerAddress);
            return this;
        }

        public Builder maxRetryTimes(int maxRetryTimes) {
            this.producerConfig.setMaxRetryTimes(maxRetryTimes);
            return this;
        }

        public Builder enableCompress(boolean enableCompress) {
            this.producerConfig.setEnableCompress(enableCompress);
            return this;
        }

        public Builder enableMessageTrace(boolean enableMessageTrace) {
            this.producerConfig.setEnableMessageTrace(enableMessageTrace);
            return this;
        }

        public Builder showInfoLevelSendMsgLog(boolean showInfoLevelSendMsgLog) {
            this.producerConfig.setShowInfoLevelSendMsgLog(showInfoLevelSendMsgLog);
            return this;
        }

        public Builder remoteCallRetryWaitTime(int remoteCallRetryWaitTime) {
            this.producerConfig.setRemoteCallRetryWaitTime(remoteCallRetryWaitTime);
            return this;
        }

        public Builder refreshRouteRetryWaitTime(int refreshRouteRetryWaitTime) {
            this.producerConfig.setRefreshRouteRetryWaitTime(refreshRouteRetryWaitTime);
            return this;
        }

        public Builder maxMsgSize(int maxMsgSize) {
            this.producerConfig.setMaxMsgSize(maxMsgSize);
            return this;
        }

        public Builder communicationFrameMaxLength(int frameMaxLength) {
            System.setProperty("communication.frame.max.length", String.valueOf(frameMaxLength));
            return this;
        }

        public Builder sendTimeout(int sendTimeout) {
            this.producerConfig.setSendTimeout(sendTimeout);
            return this;
        }

        public ProducerConfig build() {
            return this.producerConfig;
        }
    }
}

