/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.sdk;

import com.jcloud.jcq.client.Exception.ClientException;
import com.jcloud.jcq.client.consumer.ConsumerFactory;
import com.jcloud.jcq.client.consumer.SubscribeConsumer;
import com.jcloud.jcq.client.producer.ProducerFactory;
import com.jcloud.jcq.common.message.MessageType;
import com.jcloud.jcq.sdk.auth.UserCredential;
import com.jcloud.jcq.sdk.consumer.Consumer;
import com.jcloud.jcq.sdk.consumer.ConsumerConfig;
import com.jcloud.jcq.sdk.consumer.PullConsumer;
import com.jcloud.jcq.sdk.consumer.PullConsumerConfig;
import com.jcloud.jcq.sdk.consumer.impl.DefaultConsumerImpl;
import com.jcloud.jcq.sdk.consumer.impl.DefaultPullConsumerImpl;
import com.jcloud.jcq.sdk.producer.GlobalOrderProducer;
import com.jcloud.jcq.sdk.producer.Producer;
import com.jcloud.jcq.sdk.producer.ProducerConfig;
import com.jcloud.jcq.sdk.producer.impl.DefaultGlobalOrderProducerImpl;
import com.jcloud.jcq.sdk.producer.impl.DefaultProducerImpl;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class JCQClientFactory {
    private static final JCQClientFactory instance = new JCQClientFactory();
    private ProducerFactory producerFactory;
    private ConsumerFactory consumerFactory;
    private ConcurrentMap<com.jcloud.jcq.client.producer.Producer, Producer> producers = new ConcurrentHashMap<com.jcloud.jcq.client.producer.Producer, Producer>();
    private ConcurrentMap<com.jcloud.jcq.client.producer.Producer, GlobalOrderProducer> orderProducers = new ConcurrentHashMap<com.jcloud.jcq.client.producer.Producer, GlobalOrderProducer>();
    private ConcurrentMap<com.jcloud.jcq.client.consumer.Consumer, Consumer> consumers = new ConcurrentHashMap<com.jcloud.jcq.client.consumer.Consumer, Consumer>();
    private ConcurrentMap<com.jcloud.jcq.client.consumer.Consumer, PullConsumer> pullConsumers = new ConcurrentHashMap<com.jcloud.jcq.client.consumer.Consumer, PullConsumer>();

    private JCQClientFactory() {
        this.producerFactory = ProducerFactory.getInstance();
        this.consumerFactory = ConsumerFactory.getInstance();
    }

    public static JCQClientFactory getInstance() {
        return instance;
    }

    public synchronized Producer createProducer(UserCredential userCredential, ProducerConfig producerConfig) throws ClientException {
        com.jcloud.jcq.client.producer.ProducerConfig configOfNativeClient = this.toNativeClientConfig(producerConfig);
        configOfNativeClient.setToken(userCredential.getToken());
        com.jcloud.jcq.client.producer.Producer producer = this.producerFactory.createProducer(userCredential.getAccessKey(), userCredential.getSecretKey(), configOfNativeClient);
        Producer sdkProducer = (Producer)this.producers.get(producer);
        if (sdkProducer == null) {
            sdkProducer = new DefaultProducerImpl(producer);
            this.producers.put(producer, sdkProducer);
        }
        return sdkProducer;
    }

    public synchronized GlobalOrderProducer createGlobalOrderProducer(UserCredential userCredential, ProducerConfig producerConfig) throws ClientException {
        com.jcloud.jcq.client.producer.ProducerConfig configOfNativeClient = this.toNativeClientConfig(producerConfig);
        configOfNativeClient.setMessageType(MessageType.ORDER);
        configOfNativeClient.setToken(userCredential.getToken());
        com.jcloud.jcq.client.producer.Producer producer = this.producerFactory.createProducer(userCredential.getAccessKey(), userCredential.getSecretKey(), configOfNativeClient);
        GlobalOrderProducer globalOrderProducer = (GlobalOrderProducer)this.orderProducers.get(producer);
        if (globalOrderProducer == null) {
            globalOrderProducer = new DefaultGlobalOrderProducerImpl(producer);
            this.orderProducers.put(producer, globalOrderProducer);
        }
        return globalOrderProducer;
    }

    public synchronized Consumer createConsumer(UserCredential userCredential, ConsumerConfig consumerConfig) throws ClientException {
        com.jcloud.jcq.client.consumer.ConsumerConfig configOfNativeClient = this.toNativeClientConfig(consumerConfig);
        configOfNativeClient.setToken(userCredential.getToken());
        SubscribeConsumer consumer = this.consumerFactory.createSubscribeConsumer(userCredential.getAccessKey(), userCredential.getSecretKey(), configOfNativeClient);
        Consumer sdkConsumer = (Consumer)this.consumers.get(consumer);
        if (sdkConsumer == null) {
            sdkConsumer = new DefaultConsumerImpl(consumer);
            this.consumers.put(consumer, sdkConsumer);
        }
        return sdkConsumer;
    }

    public synchronized Consumer createGlobalFIFOConsumer(UserCredential userCredential, ConsumerConfig consumerConfig) throws ClientException {
        com.jcloud.jcq.client.consumer.ConsumerConfig configOfNativeClient = this.toNativeClientConfig(consumerConfig);
        configOfNativeClient.setToken(userCredential.getToken());
        configOfNativeClient.setRecommendedBatchSizePerPush(1);
        SubscribeConsumer consumer = this.consumerFactory.createSubscribeConsumer(userCredential.getAccessKey(), userCredential.getSecretKey(), configOfNativeClient);
        Consumer sdkConsumer = (Consumer)this.consumers.get(consumer);
        if (sdkConsumer == null) {
            sdkConsumer = new DefaultConsumerImpl(consumer);
            this.consumers.put(consumer, sdkConsumer);
        }
        return sdkConsumer;
    }

    public synchronized PullConsumer createPullConsumer(UserCredential userCredential, PullConsumerConfig pullConsumerConfig) throws ClientException {
        com.jcloud.jcq.client.consumer.ConsumerConfig configOfNativeClient = this.toNativeClientConfig(pullConsumerConfig);
        configOfNativeClient.setToken(userCredential.getToken());
        com.jcloud.jcq.client.consumer.PullConsumer pullConsumer = this.consumerFactory.createPullConsumer(userCredential.getAccessKey(), userCredential.getSecretKey(), configOfNativeClient);
        PullConsumer sdkPullConsumer = (PullConsumer)this.pullConsumers.get(pullConsumer);
        if (sdkPullConsumer == null) {
            sdkPullConsumer = new DefaultPullConsumerImpl(pullConsumer);
            this.pullConsumers.put(pullConsumer, sdkPullConsumer);
        }
        return sdkPullConsumer;
    }

    public synchronized PullConsumer createGlobalFIFOPullConsumer(UserCredential userCredential, PullConsumerConfig pullConsumerConfig) throws ClientException {
        com.jcloud.jcq.client.consumer.ConsumerConfig configOfNativeClient = this.toNativeClientConfig(pullConsumerConfig);
        configOfNativeClient.setToken(userCredential.getToken());
        configOfNativeClient.setRecommendedBatchSizePerPush(1);
        com.jcloud.jcq.client.consumer.PullConsumer pullConsumer = this.consumerFactory.createPullConsumer(userCredential.getAccessKey(), userCredential.getSecretKey(), configOfNativeClient);
        PullConsumer sdkPullConsumer = (PullConsumer)this.pullConsumers.get(pullConsumer);
        if (sdkPullConsumer == null) {
            sdkPullConsumer = new DefaultPullConsumerImpl(pullConsumer);
            this.pullConsumers.put(pullConsumer, sdkPullConsumer);
        }
        return sdkPullConsumer;
    }

    private com.jcloud.jcq.client.consumer.ConsumerConfig toNativeClientConfig(ConsumerConfig consumerConfig) {
        com.jcloud.jcq.client.consumer.ConsumerConfig configOfNativeClient = new com.jcloud.jcq.client.consumer.ConsumerConfig();
        configOfNativeClient.setConsumerGroupId(consumerConfig.getConsumerGroupId());
        configOfNativeClient.setMetaServerAddress(consumerConfig.getMetaServerAddress());
        configOfNativeClient.setMaxRetryTimes(consumerConfig.getMaxRetryTimes());
        configOfNativeClient.setDefaultConsumePosition(consumerConfig.getDefaultConsumePosition());
        configOfNativeClient.setRecommendedBatchSizePerPush(consumerConfig.getMaxBatchSizePerPush());
        configOfNativeClient.setConsumePoolCoreSize(consumerConfig.getConsumePoolCoreSize());
        configOfNativeClient.setMessageBufferSize(consumerConfig.getMessageBufferSize());
        configOfNativeClient.setAckPoolCoreSize(consumerConfig.getAckPoolCoreSize());
        configOfNativeClient.setAckBufferSize(consumerConfig.getAckBufferSize());
        configOfNativeClient.setConsumeMaxRetryTimes(consumerConfig.getConsumeMaxRetryTimes());
        configOfNativeClient.setMessageTraceOn(consumerConfig.isEnableMessageTrace());
        configOfNativeClient.setRemoteCallRetryWaitTime(consumerConfig.getRemoteCallRetryWaitTime());
        configOfNativeClient.setRefreshRouteRetryWaitTime(consumerConfig.getRefreshRouteRetryWaitTime());
        return configOfNativeClient;
    }

    private com.jcloud.jcq.client.consumer.ConsumerConfig toNativeClientConfig(PullConsumerConfig pullConsumerConfig) {
        com.jcloud.jcq.client.consumer.ConsumerConfig configOfNativeClient = new com.jcloud.jcq.client.consumer.ConsumerConfig();
        configOfNativeClient.setConsumerGroupId(pullConsumerConfig.getConsumerGroupId());
        configOfNativeClient.setMetaServerAddress(pullConsumerConfig.getMetaServerAddress());
        configOfNativeClient.setMaxRetryTimes(pullConsumerConfig.getMaxRetryTimes());
        configOfNativeClient.setDefaultConsumePosition(pullConsumerConfig.getDefaultConsumePosition());
        configOfNativeClient.setRecommendedBatchSizePerPush(pullConsumerConfig.getMaxBatchSizePerPull());
        configOfNativeClient.setMessageTraceOn(pullConsumerConfig.isEnableMessageTrace());
        configOfNativeClient.setRemoteCallRetryWaitTime(pullConsumerConfig.getRemoteCallRetryWaitTime());
        configOfNativeClient.setRefreshRouteRetryWaitTime(pullConsumerConfig.getRefreshRouteRetryWaitTime());
        return configOfNativeClient;
    }

    private com.jcloud.jcq.client.producer.ProducerConfig toNativeClientConfig(ProducerConfig producerConfig) {
        com.jcloud.jcq.client.producer.ProducerConfig configOfNativeClient = new com.jcloud.jcq.client.producer.ProducerConfig();
        configOfNativeClient.setMetaServerAddress(producerConfig.getMetaServerAddress());
        configOfNativeClient.setMaxRetryTimes(producerConfig.getMaxRetryTimes());
        configOfNativeClient.setEnableCompress(producerConfig.isEnableCompress());
        configOfNativeClient.setMessageTraceOn(producerConfig.isEnableMessageTrace());
        configOfNativeClient.setShowInfoLevelSendMsgLog(producerConfig.isShowInfoLevelSendMsgLog());
        configOfNativeClient.setRemoteCallRetryWaitTime(producerConfig.getRemoteCallRetryWaitTime());
        configOfNativeClient.setRefreshRouteRetryWaitTime(producerConfig.getRefreshRouteRetryWaitTime());
        configOfNativeClient.setMaxMsgSize(producerConfig.getMaxMsgSize());
        configOfNativeClient.setSendTimeout(producerConfig.getSendTimeout());
        return configOfNativeClient;
    }
}

