/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.protocol.client;

import com.jcloud.jcq.common.auth.Auth;
import com.jcloud.jcq.common.client.ClientInstanceType;
import com.jcloud.jcq.common.utils.StringUtils;
import com.jcloud.jcq.protocol.Request;

@Auth(scope=Auth.Scope.OUTER)
public class UnregisterClientRequest
extends Request {
    private String clientId;
    private String consumerGroupId;
    private ClientInstanceType clientInstanceType;

    public UnregisterClientRequest() {
        this.requestCode = (short)1101;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public void setConsumerGroupId(String consumerGroupId) {
        this.consumerGroupId = consumerGroupId;
    }

    public ClientInstanceType getClientInstanceType() {
        return this.clientInstanceType;
    }

    public void setClientInstanceType(ClientInstanceType clientInstanceType) {
        this.clientInstanceType = clientInstanceType;
    }

    @Override
    public String validate() {
        String result = super.validate();
        if (result == null) {
            if (StringUtils.isEmpty(this.clientId)) {
                result = "clientId is empty";
            } else if (this.clientInstanceType == null || this.clientInstanceType == ClientInstanceType.UNKNOWN) {
                result = "clientInstanceType is null or UNKNOWN";
            } else if (this.clientInstanceType == ClientInstanceType.CONSUMER && StringUtils.isEmpty(this.consumerGroupId)) {
                result = "clientInstanceType is CONSUMER but consumerGroupId is empty";
            }
        }
        return result;
    }

    @Override
    public String toString() {
        return "UnregisterClientRequest{clientId='" + this.clientId + '\'' + ", consumerGroupId='" + this.consumerGroupId + '\'' + ", clientInstanceType=" + (Object)((Object)this.clientInstanceType) + ", requestId='" + this.requestId + '\'' + ", version='" + this.version + '\'' + ", requestCode=" + this.requestCode + ", properties=" + this.properties + ", createTimestamp=" + this.createTimestamp + '}';
    }
}

