/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.protocol.client;

import com.jcloud.jcq.common.auth.Auth;
import com.jcloud.jcq.common.client.ClientInstanceType;
import com.jcloud.jcq.common.utils.StringUtils;
import com.jcloud.jcq.protocol.Request;
import java.util.List;

@Auth(scope=Auth.Scope.OUTER)
public class GetTopicRouteInfoRequestV2
extends Request {
    private List<String> topics;
    private String clientId;
    private String consumerGroupId;
    private ClientInstanceType clientInstanceType;

    public GetTopicRouteInfoRequestV2() {
        this.requestCode = (short)206;
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public void setTopics(List<String> topics) {
        this.topics = topics;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public void setConsumerGroupId(String consumerGroupId) {
        this.consumerGroupId = consumerGroupId;
    }

    public ClientInstanceType getClientInstanceType() {
        return this.clientInstanceType;
    }

    public void setClientInstanceType(ClientInstanceType clientInstanceType) {
        this.clientInstanceType = clientInstanceType;
    }

    @Override
    public String validate() {
        String result = super.validate();
        if (result == null) {
            if (this.topics == null || this.topics.isEmpty()) {
                result = "topics is empty";
            } else if (StringUtils.isEmpty(this.clientId)) {
                result = "clientId is empty";
            } else if (!ClientInstanceType.anyExternalType(this.clientInstanceType)) {
                result = "clientInstanceType is null or UNKNOWN";
            } else if (this.clientInstanceType == ClientInstanceType.CONSUMER && StringUtils.isEmpty(this.consumerGroupId)) {
                result = "clientInstanceType is CONSUMER but consumerGroupId is empty";
            }
        }
        return result;
    }

    @Override
    public String toString() {
        return "GetTopicRouteInfoRequestV2{topics=" + this.topics + ", clientId='" + this.clientId + '\'' + ", consumerGroupId='" + this.consumerGroupId + '\'' + ", clientInstanceType=" + (Object)((Object)this.clientInstanceType) + ", requestId='" + this.requestId + '\'' + ", version='" + this.version + '\'' + ", requestCode=" + this.requestCode + ", properties=" + this.properties + ", createTimestamp=" + this.createTimestamp + '}';
    }
}

