/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.protocol.client;

import com.jcloud.jcq.common.message.AckAction;
import com.jcloud.jcq.common.utils.StringBuilderWrapper;
import com.jcloud.jcq.common.utils.StringUtils;
import com.jcloud.jcq.common.utils.ThreadLocalStringBuilderUtils;
import com.jcloud.jcq.common.version.JcqVersion;
import com.jcloud.jcq.protocol.Request;

public class AckMessageRequest
extends Request {
    protected String topic;
    protected AckAction ackAction = AckAction.SUCCESS;
    protected long ackIndex;
    protected String userId;
    protected String consumerGroupId;

    public AckMessageRequest() {
        this.requestCode = (short)104;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public AckAction getAckAction() {
        return this.ackAction;
    }

    public void setAckAction(AckAction ackAction) {
        this.ackAction = ackAction;
    }

    public long getAckIndex() {
        return this.ackIndex;
    }

    public void setAckIndex(long ackIndex) {
        this.ackIndex = ackIndex;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public void setConsumerGroupId(String consumerGroupId) {
        this.consumerGroupId = consumerGroupId;
    }

    @Override
    public String validate() {
        String result = super.validate();
        if (!StringUtils.isEmpty(result)) {
            return result;
        }
        if (StringUtils.isEmpty(this.getAccessKey())) {
            return "accessKey is null";
        }
        if (StringUtils.isEmpty(this.topic)) {
            return "topic is empty";
        }
        JcqVersion version = JcqVersion.transform(this.getVersion());
        if (version == null) {
            return "version is invalid";
        }
        if (version.getValue() >= JcqVersion.V1_0_2.getValue() && StringUtils.isEmpty(this.consumerGroupId)) {
            return "consumerGroupId is empty";
        }
        if (this.ackAction == null) {
            return "ackAction is null";
        }
        if (this.ackIndex < 0L) {
            return "ackIndex < 0";
        }
        return null;
    }

    @Override
    public String toString() {
        return "AckMessageRequest{requestId='" + this.requestId + '\'' + ",version='" + this.version + '\'' + ",requestCode=" + this.requestCode + ",properties=" + this.properties + ",createTimestamp=" + this.createTimestamp + ",topic='" + this.topic + '\'' + ",consumerGroupId=" + this.consumerGroupId + ",ackAction=" + (Object)((Object)this.ackAction) + ",ackIndex=" + this.ackIndex + "}";
    }

    @Override
    public StringBuilderWrapper toStringBuilderWrapper() {
        return ThreadLocalStringBuilderUtils.append("AckMessageRequest{").append("requestId='").append(this.requestId).append(Character.valueOf('\'')).append(",version='").append(this.version).append(Character.valueOf('\'')).append(",requestCode=").append(this.requestCode).append(",properties=").append((Object)this.properties).append(",createTimestamp=").append(this.createTimestamp).append(",topic='").append(this.topic).append(Character.valueOf('\'')).append(",consumerGroupId=").append(this.consumerGroupId).append(",ackAction=").append((Object)this.ackAction).append(",ackIndex=").append(this.ackIndex).append(Character.valueOf('}'));
    }
}

