/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.protocol;

import com.jcloud.jcq.protocol.Request;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignSourceGenerator {
    private static final Logger logger = LoggerFactory.getLogger(SignSourceGenerator.class);
    private static ConcurrentMap<Class, ConcurrentMap<String, PropertyDescriptor>> propertyDescriptorMap = new ConcurrentHashMap<Class, ConcurrentMap<String, PropertyDescriptor>>();
    private static ConcurrentMap<Class, ConcurrentMap<String, Method>> requestPropertyGetMethod = new ConcurrentHashMap<Class, ConcurrentMap<String, Method>>();

    public static String getSignSource(Request request) {
        if (request == null) {
            return null;
        }
        ConcurrentHashMap<String, Object> propertyDescriptors = (ConcurrentHashMap<String, Object>)propertyDescriptorMap.get(request.getClass());
        if (propertyDescriptors == null) {
            try {
                propertyDescriptors = new ConcurrentHashMap<String, Object>();
                PropertyDescriptor[] descriptors = Introspector.getBeanInfo(request.getClass(), Object.class).getPropertyDescriptors();
                for (PropertyDescriptor descriptor : descriptors) {
                    propertyDescriptors.put(descriptor.getName(), descriptor);
                }
                propertyDescriptorMap.put(request.getClass(), propertyDescriptors);
            }
            catch (IntrospectionException e) {
                logger.warn("got exception:{} when get property descriptors of class:{}", (Object)e, (Object)request.getClass().getSimpleName());
                return null;
            }
        }
        if (!requestPropertyGetMethod.containsKey(request.getClass())) {
            requestPropertyGetMethod.put(request.getClass(), new ConcurrentHashMap());
        }
        TreeMap<String, String> fieldValueMap = new TreeMap<String, String>();
        fieldValueMap.putAll(request.getProperties());
        for (Map.Entry entry : propertyDescriptors.entrySet()) {
            Object fieldValue;
            Method readMethod;
            String fieldName = (String)entry.getKey();
            if (fieldName.equals("properties") || fieldName.equals("jcloudToken")) continue;
            ConcurrentMap subMap = (ConcurrentMap)requestPropertyGetMethod.get(request.getClass());
            if (subMap.containsKey(fieldName)) {
                readMethod = (Method)subMap.get(fieldName);
            } else {
                readMethod = ((PropertyDescriptor)entry.getValue()).getReadMethod();
                if (readMethod != null) {
                    readMethod.setAccessible(true);
                    subMap.put(fieldName, readMethod);
                }
            }
            try {
                fieldValue = readMethod.invoke((Object)request, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                logger.warn("got exception:{} when invoke method:{} on request:{}", new Object[]{e, readMethod.getName(), request});
                continue;
            }
            fieldValueMap.put(fieldName, fieldValue == null ? "" : fieldValue.toString());
            fieldValueMap.remove("signature");
        }
        fieldValueMap.remove("signature");
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : fieldValueMap.entrySet()) {
            stringBuilder.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append("&");
        }
        return stringBuilder.toString();
    }
}

