/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.communication.protocol;

import com.jcloud.jcq.common.client.ClientType;
import com.jcloud.jcq.communication.core.CommunicationSystemConfig;
import com.jcloud.jcq.communication.exception.CommunicationUnitException;
import com.jcloud.jcq.communication.protocol.CommunicationType;
import com.jcloud.jcq.communication.protocol.CommunicationUnit;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunicationUnitUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)CommunicationUnitUtils.class.getName());
    private static AtomicInteger requestNumberSeed = new AtomicInteger(0);
    private static final int MAX_DECODE_BODY_LEN = CommunicationUnitUtils.getMaskOfInt(CommunicationSystemConfig.frameMaxLength);

    private static int getMaskOfInt(int number) {
        if (number <= 0) {
            return 0;
        }
        int result = 0;
        while (number > 0) {
            number >>= 1;
            result = (result << 1) + 1;
        }
        logger.info("getMaskOfInt return result is : {}", (Object)result);
        return result;
    }

    public static int createNewRequestNumber() {
        return requestNumberSeed.incrementAndGet();
    }

    public static CommunicationUnit createHeartbeatRequestCommunicationUnit() {
        CommunicationUnit cu = new CommunicationUnit();
        cu.setRequestNumber(CommunicationUnitUtils.createNewRequestNumber());
        cu.setCode((short)100);
        cu.setClientType(ClientType.JAVA);
        cu.setCommunicationType(CommunicationType.SYNC_REQUEST);
        return cu;
    }

    public static CommunicationUnit createRequestCommunicationUnit(short requestCode, ClientType clientType, CommunicationType ct) {
        CommunicationUnit cu = new CommunicationUnit();
        cu.setRequestNumber(CommunicationUnitUtils.createNewRequestNumber());
        cu.setCode(requestCode);
        cu.setClientType(clientType);
        cu.setCommunicationType(ct);
        return cu;
    }

    public static CommunicationUnit createResponseCommunicationUnit(short responseCode, CommunicationType ct) {
        CommunicationUnit cu = new CommunicationUnit();
        cu.setCode(responseCode);
        cu.setCommunicationType(ct);
        return cu;
    }

    public static CommunicationUnit createResponseCommunicationUnit(int requestNumber, short responseCode, CommunicationType ct) {
        CommunicationUnit cu = new CommunicationUnit();
        cu.setRequestNumber(requestNumber);
        cu.setCode(responseCode);
        cu.setCommunicationType(ct);
        return cu;
    }

    public static CommunicationUnit decodeFromByteArray(byte[] array) throws CommunicationUnitException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(array);
        return CommunicationUnitUtils.decodeFromByteBuffer(byteBuffer);
    }

    public static CommunicationUnit decodeFromByteBuffer(ByteBuffer byteBuffer) throws CommunicationUnitException {
        int oriBodyLength = byteBuffer.getInt();
        int bodyLength = oriBodyLength & MAX_DECODE_BODY_LEN;
        byte[] headerData = new byte[8];
        byteBuffer.get(headerData);
        CommunicationUnit cu = CommunicationUnitUtils.decodeHeaderFromByteArray(headerData);
        byte[] bodyData = null;
        if (bodyLength > 0) {
            bodyData = new byte[bodyLength];
            byteBuffer.get(bodyData);
        }
        cu.setData(bodyData);
        return cu;
    }

    public static CommunicationUnit decodeRequestToPoolBuffer(ByteBuffer byteBuffer) throws CommunicationUnitException {
        int oriBodyLength = byteBuffer.getInt();
        int bodyLength = oriBodyLength & MAX_DECODE_BODY_LEN;
        byte[] headerData = new byte[8];
        byteBuffer.get(headerData);
        CommunicationUnit cu = CommunicationUnitUtils.decodeHeaderFromByteArray(headerData);
        if (bodyLength > 0) {
            if (CommunicationType.isRequest(cu.getCommunicationType().getCode())) {
                ByteBuffer body = CommunicationUnit.getPooledByteBuffer(bodyLength);
                byteBuffer.limit(byteBuffer.position() + bodyLength);
                body.put(byteBuffer);
                body.flip();
                cu.setPooledBufferRequest(body);
            } else {
                byte[] bodyData = new byte[bodyLength];
                byteBuffer.get(bodyData);
                cu.setData(bodyData);
            }
        }
        return cu;
    }

    public static CommunicationUnit decodeHeaderFromByteArray(byte[] headerArray) throws CommunicationUnitException {
        if (headerArray.length < 8) {
            throw new CommunicationUnitException(String.format("The header byte array's length is invalid, length: %d", headerArray.length));
        }
        CommunicationUnit cu = new CommunicationUnit();
        ByteBuffer headerBuffer = ByteBuffer.wrap(headerArray);
        cu.setCommunicationType(CommunicationType.valueOf(headerBuffer.get()));
        cu.setClientType(ClientType.valueOf(headerBuffer.get()));
        cu.setCode(headerBuffer.getShort());
        cu.setRequestNumber(headerBuffer.getInt());
        return cu;
    }

    public static ByteBuffer encode2ByteBuffer(CommunicationUnit communicationUnit) {
        int length = 4;
        byte[] headerData = communicationUnit.encodeHeader2ByteArray();
        length += headerData.length;
        if (communicationUnit.getData() != null) {
            length += communicationUnit.getData().length;
        }
        ByteBuffer result = ByteBuffer.allocate(length);
        result.putInt(communicationUnit.getData() == null ? 0 : communicationUnit.getData().length);
        result.put(headerData);
        if (communicationUnit.getData() != null) {
            result.put(communicationUnit.getData());
        }
        result.flip();
        return result;
    }
}

