/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.communication.protocol;

import com.jcloud.jcq.common.client.ClientType;
import com.jcloud.jcq.common.utils.StringBuilderWrapper;
import com.jcloud.jcq.common.utils.StringUtils;
import com.jcloud.jcq.common.utils.ThreadLocalStringBuilderUtils;
import com.jcloud.jcq.communication.protocol.CommunicationType;
import com.jcloud.jcq.communication.protocol.ICommunicationUnit;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class CommunicationUnit
implements ICommunicationUnit {
    private int requestNumber = -1;
    private CommunicationType communicationType;
    private ClientType clientType;
    private short code;
    private transient byte[] data;
    private transient ByteBuffer pooledBufferRequest;
    public static final int HEADER_LENGTH_IN_BYTE = 8;
    private transient ByteBuffer[] dataByteBuffer;
    private static ConcurrentLinkedQueue<ByteBuffer> linkedBufferPool = new ConcurrentLinkedQueue();
    private static int DEAULT_MAX_POOL_SIZE = 64;
    private static int DEFAULT_BYTEBUFFER_SZIE = 65536;
    private static AtomicInteger queueSize = new AtomicInteger(0);
    private static AtomicInteger bufferPoolSize = new AtomicInteger(0);
    private AtomicBoolean isReleasePooledRequest = new AtomicBoolean(false);
    private Object object;

    public byte[] encodeHeader2ByteArray() {
        ByteBuffer headerBuffer = ByteBuffer.allocate(8);
        headerBuffer.put(this.getCommunicationType().getCode());
        headerBuffer.put(this.getClientType().getCode());
        headerBuffer.putShort(this.getCode());
        headerBuffer.putInt(this.getRequestNumber());
        return headerBuffer.array();
    }

    @Override
    public int getRequestNumber() {
        return this.requestNumber;
    }

    @Override
    public void setRequestNumber(int requestNumber) {
        this.requestNumber = requestNumber;
    }

    @Override
    public CommunicationType getCommunicationType() {
        return this.communicationType;
    }

    @Override
    public void setCommunicationType(CommunicationType communicationType) {
        this.communicationType = communicationType;
    }

    @Override
    public ClientType getClientType() {
        return this.clientType;
    }

    @Override
    public void setClientType(ClientType clientType) {
        this.clientType = clientType;
    }

    @Override
    public short getCode() {
        return this.code;
    }

    public void setCode(short code) {
        this.code = code;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public void setObject(Object object) {
        this.object = object;
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public ByteBuffer[] getDataByteBuffer() {
        return this.dataByteBuffer;
    }

    @Override
    public void setDataByteBuffer(ByteBuffer[] dataByteBuffer) {
        this.dataByteBuffer = dataByteBuffer;
    }

    @Override
    public ByteBuffer getPooledBufferRequest() {
        if (!this.isReleasePooledRequest.get()) {
            return this.pooledBufferRequest;
        }
        return null;
    }

    public void setPooledBufferRequest(ByteBuffer pooledBufferRequest) {
        this.pooledBufferRequest = pooledBufferRequest;
    }

    public static ByteBuffer getPooledByteBuffer(int size) {
        if (size > DEFAULT_BYTEBUFFER_SZIE) {
            return ByteBuffer.allocate(size);
        }
        ByteBuffer byteBuffer = linkedBufferPool.poll();
        if (byteBuffer != null) {
            queueSize.decrementAndGet();
            return byteBuffer;
        }
        if (bufferPoolSize.get() < DEAULT_MAX_POOL_SIZE) {
            byteBuffer = ByteBuffer.allocate(DEFAULT_BYTEBUFFER_SZIE);
            bufferPoolSize.incrementAndGet();
        } else {
            byteBuffer = ByteBuffer.allocate(size);
        }
        return byteBuffer;
    }

    @Override
    public void releasePooledBufferRequest() {
        if (this.pooledBufferRequest == null) {
            return;
        }
        ByteBuffer byteBuffer = this.pooledBufferRequest;
        if (this.isReleasePooledRequest.compareAndSet(false, true) && byteBuffer != null && byteBuffer.capacity() == DEFAULT_BYTEBUFFER_SZIE) {
            if (queueSize.incrementAndGet() < DEAULT_MAX_POOL_SIZE) {
                byteBuffer.clear();
                linkedBufferPool.add(byteBuffer);
            } else {
                queueSize.decrementAndGet();
            }
        }
        this.pooledBufferRequest = null;
    }

    public AtomicBoolean getIsReleasePooledRequest() {
        return this.isReleasePooledRequest;
    }

    public void setIsReleasePooledRequest(boolean isReleased) {
        this.isReleasePooledRequest.set(isReleased);
    }

    public String toString() {
        HashMap<String, String> kvmap = new HashMap<String, String>();
        kvmap.put("RequestNumber", Integer.toString(this.getRequestNumber()));
        kvmap.put("CommunicationType", this.getCommunicationType() != null ? Byte.toString(this.getCommunicationType().getCode()) : "null");
        kvmap.put("ClientType", this.getClientType() != null ? Byte.toString(this.getClientType().getCode()) : "null");
        kvmap.put("RequestCode", Short.toString(this.getCode()));
        return StringUtils.toStringHelper(this.getClass().getName(), kvmap);
    }

    @Override
    public StringBuilderWrapper toStringBuilderWrapper() {
        return ThreadLocalStringBuilderUtils.append(this.getClass().getName()).append("-[").append("RequestNumber=").append(this.getRequestNumber()).append(",CommunicationType=").append(this.getCommunicationType().getCode()).append(",ClientType=").append(this.getClientType().getCode()).append(",RequestCode=").append(this.getCode()).append("]");
    }
}

