/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.communication.core;

import com.jcloud.jcq.common.utils.SystemClock;
import com.jcloud.jcq.communication.common.SemaphoreReleaseOnlyOnce;
import com.jcloud.jcq.communication.portal.InvokeCallback;
import com.jcloud.jcq.communication.protocol.ICommunicationUnit;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ResponseFuture {
    private final int requestNumber;
    private final long timeoutMillis;
    private final InvokeCallback invokeCallback;
    private final SemaphoreReleaseOnlyOnce once;
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private final long creationTimestamp = SystemClock.now();
    private final AtomicBoolean callbackOnlyOnce = new AtomicBoolean(false);
    private volatile ICommunicationUnit responseUnit;
    private volatile boolean requestSentSuccessfully = true;
    private volatile Throwable cause;

    public ResponseFuture(int requestNumber, long timeoutMillis, InvokeCallback invokeCallback, Semaphore semaphore) {
        this.requestNumber = requestNumber;
        this.timeoutMillis = timeoutMillis;
        this.invokeCallback = invokeCallback;
        this.once = new SemaphoreReleaseOnlyOnce(semaphore);
    }

    public void executeInvokeCallback() {
        if (this.getInvokeCallback() != null && this.getCallbackOnlyOnce().compareAndSet(false, true)) {
            this.getInvokeCallback().operationComplete(this);
        }
    }

    public void release() {
        if (this.getOnce() != null) {
            this.getOnce().release();
        }
    }

    public boolean isTimeout() {
        long diff = SystemClock.now() - this.getCreationTimestamp();
        return diff > this.getTimeoutMillis();
    }

    public void putResponseUnit(ICommunicationUnit responseUnit) {
        this.responseUnit = responseUnit;
        this.getCountDownLatch().countDown();
    }

    public ICommunicationUnit getResponseUnit() throws InterruptedException {
        ICommunicationUnit rs = null;
        if (this.getCountDownLatch().await(this.getTimeoutMillis(), TimeUnit.MILLISECONDS)) {
            rs = this.responseUnit;
        }
        return rs;
    }

    public ICommunicationUnit getResponseUnitImmediately() throws InterruptedException {
        return this.responseUnit;
    }

    public int getRequestNumber() {
        return this.requestNumber;
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public InvokeCallback getInvokeCallback() {
        return this.invokeCallback;
    }

    public SemaphoreReleaseOnlyOnce getOnce() {
        return this.once;
    }

    public CountDownLatch getCountDownLatch() {
        return this.countDownLatch;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public AtomicBoolean getCallbackOnlyOnce() {
        return this.callbackOnlyOnce;
    }

    public boolean isRequestSentSuccessfully() {
        return this.requestSentSuccessfully;
    }

    public void setRequestSentSuccessfully(boolean requestSentSuccessfully) {
        this.requestSentSuccessfully = requestSentSuccessfully;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
    }
}

