/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.communication.core;

import com.jcloud.jcq.common.utils.CommunicationUtils;
import com.jcloud.jcq.communication.core.CommunicationSystemConfig;
import com.jcloud.jcq.communication.protocol.CommunicationUnit;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEncoder
extends MessageToByteEncoder<CommunicationUnit> {
    private final Logger logger = LoggerFactory.getLogger((String)"JcqCommunication");

    protected void encode(ChannelHandlerContext ctx, CommunicationUnit communicationUnit, ByteBuf byteBuf) throws Exception {
        block8: {
            try {
                byte[] headerData = communicationUnit.encodeHeader2ByteArray();
                if (communicationUnit.getDataByteBuffer() != null) {
                    int dataLen = 0;
                    for (ByteBuffer byteBuffer : communicationUnit.getDataByteBuffer()) {
                        dataLen += byteBuffer.remaining();
                    }
                    byteBuf.writeInt(dataLen);
                    byteBuf.writeBytes(headerData);
                    for (ByteBuffer buffer : communicationUnit.getDataByteBuffer()) {
                        byteBuf.writeBytes(buffer);
                    }
                } else {
                    byteBuf.writeInt(communicationUnit.getData() == null ? 0 : communicationUnit.getData().length);
                    byteBuf.writeBytes(headerData);
                    if (communicationUnit.getData() != null) {
                        byteBuf.writeBytes(communicationUnit.getData());
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("Encode exception {} got when processing message from remote address {}.", (Object)e.toString(), (Object)CommunicationUtils.parseChannelRemoteAddr(ctx.channel()));
                if (communicationUnit != null) {
                    this.logger.error(communicationUnit.toString());
                }
                if (!CommunicationSystemConfig.closeChannelIfEncodeError) break block8;
                this.closeChannel(ctx.channel(), null);
            }
        }
    }

    private void closeChannel(Channel channel, ChannelFutureListener channelFutureListener) {
        if (channelFutureListener != null) {
            channel.close().addListener((GenericFutureListener)channelFutureListener);
        } else {
            channel.close();
        }
    }
}

