/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.communication.core;

import com.jcloud.jcq.common.utils.CommunicationUtils;
import com.jcloud.jcq.communication.core.CommunicationSystemConfig;
import com.jcloud.jcq.communication.protocol.CommunicationUnit;
import com.jcloud.jcq.communication.protocol.CommunicationUnitUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDecoder
extends LengthFieldBasedFrameDecoder {
    private final Logger logger = LoggerFactory.getLogger((String)"JcqCommunication");
    private static final int FRAME_MAX_LENGTH = CommunicationSystemConfig.frameMaxLength;
    private boolean cuBodyPooledEnable = false;

    public DefaultDecoder() {
        super(FRAME_MAX_LENGTH, 0, 4, 8, 0);
        this.logger.info("FRAME_MAX_LENGTH={}", (Object)FRAME_MAX_LENGTH);
    }

    public DefaultDecoder(boolean cuBodyPooledEnable) {
        super(FRAME_MAX_LENGTH, 0, 4, 8, 0);
        this.logger.info("FRAME_MAX_LENGTH={}", (Object)FRAME_MAX_LENGTH);
        this.cuBodyPooledEnable = cuBodyPooledEnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        ByteBuf frame = null;
        try {
            frame = (ByteBuf)super.decode(ctx, in);
            if (null == frame) {
                Object var4_4 = null;
                return var4_4;
            }
            ByteBuffer byteBuffer = frame.nioBuffer();
            if (this.cuBodyPooledEnable) {
                CommunicationUnit communicationUnit = CommunicationUnitUtils.decodeRequestToPoolBuffer(byteBuffer);
                return communicationUnit;
            }
            CommunicationUnit communicationUnit = CommunicationUnitUtils.decodeFromByteBuffer(byteBuffer);
            return communicationUnit;
        }
        catch (Exception e) {
            if (e instanceof TooLongFrameException) {
                this.logger.warn("Decode exception {} got when processing message from remote address {}.", (Object)e.toString(), (Object)CommunicationUtils.parseChannelRemoteAddr(ctx.channel()));
            } else {
                this.logger.error("Decode exception {} got when processing message from remote address {}.", (Object)e.toString(), (Object)CommunicationUtils.parseChannelRemoteAddr(ctx.channel()));
            }
            if (CommunicationSystemConfig.closeChannelIfDecodeError) {
                this.closeChannel(ctx.channel(), null);
            }
        }
        finally {
            if (null != frame) {
                frame.release();
            }
        }
        return null;
    }

    public boolean isCuBodyPooledEnable() {
        return this.cuBodyPooledEnable;
    }

    protected void closeChannel(Channel channel, ChannelFutureListener channelFutureListener) {
        if (channelFutureListener != null) {
            channel.close().addListener((GenericFutureListener)channelFutureListener);
        } else {
            channel.close();
        }
    }
}

