/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.communication.core;

import com.jcloud.jcq.common.Pair;
import com.jcloud.jcq.common.utils.CommunicationUtils;
import com.jcloud.jcq.common.utils.SystemClock;
import com.jcloud.jcq.communication.core.ChannelEvent;
import com.jcloud.jcq.communication.core.ChannelEventType;
import com.jcloud.jcq.communication.core.ChannelWrapper;
import com.jcloud.jcq.communication.core.CommunicationAbstract;
import com.jcloud.jcq.communication.core.CommunicationServerConfig;
import com.jcloud.jcq.communication.core.DefaultChannelEventListener;
import com.jcloud.jcq.communication.core.DefaultDecoder;
import com.jcloud.jcq.communication.core.DefaultEncoder;
import com.jcloud.jcq.communication.exception.CommunicationException;
import com.jcloud.jcq.communication.exception.CommunicationTimeoutException;
import com.jcloud.jcq.communication.portal.ChannelEventListener;
import com.jcloud.jcq.communication.portal.CommunicationRequestHandler;
import com.jcloud.jcq.communication.portal.CommunicationServer;
import com.jcloud.jcq.communication.portal.InvokeCallback;
import com.jcloud.jcq.communication.portal.InvokeHook;
import com.jcloud.jcq.communication.protocol.CommunicationType;
import com.jcloud.jcq.communication.protocol.CommunicationUnit;
import com.jcloud.jcq.communication.protocol.CommunicationUnitUtils;
import com.jcloud.jcq.communication.protocol.ICommunicationUnit;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCommunicationServer
extends CommunicationAbstract
implements CommunicationServer {
    private final Logger logger = LoggerFactory.getLogger((String)"JcqCommunication");
    private ServerBootstrap serverBootstrap;
    private EventLoopGroup eventLoopGroupSelector;
    private EventLoopGroup eventLoopGroupBoss;
    private CommunicationServerConfig serverConfig;
    private ExecutorService publicExecutor;
    private ExecutorService heartBeatExecutor;
    private ChannelEventListener defaultChannelEventListener;
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(3, new CommunicationAbstract.DefaultThreadFactory(10, "CommunicationServerScheduledTask"));
    private DefaultEventExecutorGroup defaultHandlerExecutorGroup;
    private InvokeHook invokeHook;
    private int port = 0;
    private ScanChannelMapTask scanChannelMapTask = null;
    private final ConcurrentMap<Channel, ChannelWrapper> channelMap = new ConcurrentHashMap<Channel, ChannelWrapper>(512);
    private static ScheduledThreadPoolExecutor cleanExecutor;
    private static AtomicInteger serverCountInSameJVM;
    private Class decoderCls = null;
    private Class encoderCls = null;

    public DefaultCommunicationServer(CommunicationServerConfig serverConfig) {
        this(serverConfig, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultCommunicationServer(CommunicationServerConfig serverConfig, ChannelEventListener channelEventListener) {
        super(serverConfig.getServerOnewaySemaphoreValue(), serverConfig.getServerAsyncSemaphoreValue());
        this.serverBootstrap = new ServerBootstrap();
        this.serverConfig = serverConfig;
        this.defaultChannelEventListener = channelEventListener == null ? new DefaultChannelEventListener() : channelEventListener;
        int publicThreadNums = serverConfig.getServerCallbackExecutorThreads();
        int bossThreadNums = serverConfig.getServerBossThreads();
        int selectorThreadNums = serverConfig.getServerSelectorThreads();
        int workerThreadNums = serverConfig.getServerWorkerThreads();
        int cleanThreadNums = serverConfig.getServerChannelCleanWorkerThreads();
        int heartBeatThreadNums = serverConfig.getHeartBeatExecutorThreads();
        this.publicExecutor = Executors.newFixedThreadPool(publicThreadNums, new CommunicationAbstract.DefaultThreadFactory(publicThreadNums, "CommunicationServerPublicExecutor"));
        if (CommunicationUtils.isEpollAvailable()) {
            this.eventLoopGroupBoss = new EpollEventLoopGroup(bossThreadNums, (ThreadFactory)new CommunicationAbstract.DefaultThreadFactory(bossThreadNums, "CommunicationBossLoopGroup"));
            this.eventLoopGroupSelector = new EpollEventLoopGroup(selectorThreadNums, (ThreadFactory)new CommunicationAbstract.DefaultThreadFactory(selectorThreadNums, "CommunicationSelectorLoopGroup"));
        } else {
            this.eventLoopGroupBoss = new NioEventLoopGroup(bossThreadNums, (ThreadFactory)new CommunicationAbstract.DefaultThreadFactory(bossThreadNums, "CommunicationBossLoopGroup"));
            this.eventLoopGroupSelector = new NioEventLoopGroup(selectorThreadNums, (ThreadFactory)new CommunicationAbstract.DefaultThreadFactory(selectorThreadNums, "CommunicationSelectorLoopGroup"));
        }
        this.defaultHandlerExecutorGroup = new DefaultEventExecutorGroup(workerThreadNums, (ThreadFactory)new CommunicationAbstract.DefaultThreadFactory(workerThreadNums, "CommunicationServerWorkerThread"));
        Class<DefaultCommunicationServer> clazz = DefaultCommunicationServer.class;
        synchronized (DefaultCommunicationServer.class) {
            if (cleanExecutor == null) {
                cleanExecutor = new ScheduledThreadPoolExecutor(cleanThreadNums, new CommunicationAbstract.DefaultThreadFactory(cleanThreadNums, "CommunicationServerChannelCleaner"));
            }
            // ** MonitorExit[var9_9] (shouldn't be in output)
            this.heartBeatExecutor = Executors.newFixedThreadPool(heartBeatThreadNums, new CommunicationAbstract.DefaultThreadFactory(heartBeatThreadNums, "CommunicationServerHeartBeatExecutor"));
            serverCountInSameJVM.incrementAndGet();
            return;
        }
    }

    @Override
    public void start() throws InterruptedException {
        if (this.decoderCls == null) {
            this.decoderCls = DefaultDecoder.class;
        }
        if (this.encoderCls == null) {
            this.encoderCls = DefaultEncoder.class;
        }
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.serverBootstrap.group(this.eventLoopGroupBoss, this.eventLoopGroupSelector).channel(CommunicationUtils.isEpollAvailable() ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)1024)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)false)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_SNDBUF, (Object)this.serverConfig.getServerSocketSndBufSize()).childOption(ChannelOption.SO_RCVBUF, (Object)this.serverConfig.getServerSocketRcvBufSize()).localAddress((SocketAddress)new InetSocketAddress(this.serverConfig.getListenPort()))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline channelPipeline = ch.pipeline();
                channelPipeline.addLast((EventExecutorGroup)DefaultCommunicationServer.this.defaultHandlerExecutorGroup, "Encoder", (ChannelHandler)DefaultCommunicationServer.this.encoderCls.newInstance());
                channelPipeline.addLast((EventExecutorGroup)DefaultCommunicationServer.this.defaultHandlerExecutorGroup, "Decoder", (ChannelHandler)DefaultCommunicationServer.this.decoderCls.newInstance());
                channelPipeline.addLast((EventExecutorGroup)DefaultCommunicationServer.this.defaultHandlerExecutorGroup, "IdleStateHandler", (ChannelHandler)new IdleStateHandler(DefaultCommunicationServer.this.serverConfig.getServerChannelReadIdleTimeSeconds(), DefaultCommunicationServer.this.serverConfig.getServerChannelWriteIdleTimeSeconds(), DefaultCommunicationServer.this.serverConfig.getServerChannelMaxIdleTimeSeconds()));
                channelPipeline.addLast((EventExecutorGroup)DefaultCommunicationServer.this.defaultHandlerExecutorGroup, "ConnectManageHandler", (ChannelHandler)new DefaultServerConnectManageHandler());
                channelPipeline.addLast((EventExecutorGroup)DefaultCommunicationServer.this.defaultHandlerExecutorGroup, "MessageHandler", (ChannelHandler)new CommunicationAbstract.DefaultCommunicationMessageHandler());
            }
        });
        if (this.serverConfig.isServerPooledByteBufAllocatorEnable()) {
            this.serverBootstrap.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        }
        try {
            ChannelFuture sync = this.serverBootstrap.bind().sync();
            InetSocketAddress addr = (InetSocketAddress)sync.channel().localAddress();
            this.port = addr.getPort();
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
            throw new InterruptedException(String.format("this.serverBootstrap.bind().sync() InterruptedException: %s", e1.toString()));
        }
        if (this.channelEventExecutor != null) {
            this.channelEventExecutor.start();
        }
        this.executor.scheduleAtFixedRate(new CommunicationAbstract.ScanResponseTableRunnable(), 3000L, 1000L, TimeUnit.MILLISECONDS);
        if (this.scanChannelMapTask == null) {
            this.scanChannelMapTask = new ScanChannelMapTask();
            cleanExecutor.scheduleAtFixedRate(this.scanChannelMapTask, 1L, 1L, TimeUnit.MINUTES);
        }
        this.registerHandler((short)100, new DefaultHeartBeatHandler(), this.heartBeatExecutor);
    }

    @Override
    public void shutdown() {
        try {
            this.executor.shutdown();
            this.eventLoopGroupBoss.shutdownGracefully();
            this.eventLoopGroupSelector.shutdownGracefully();
            for (ChannelWrapper cw : this.channelMap.values()) {
                cw.shutdownHeartbeatService();
                cw.getChannel().close();
                this.logger.info("The communication channel {} has been closed.", (Object)cw.getChannel().toString());
            }
            if (this.channelEventExecutor != null) {
                this.channelEventExecutor.shutdown();
            }
            if (this.defaultHandlerExecutorGroup != null) {
                this.defaultHandlerExecutorGroup.shutdownGracefully();
            }
            if (this.scanChannelMapTask != null) {
                cleanExecutor.remove(this.scanChannelMapTask);
            }
            if (this.heartBeatExecutor != null) {
                this.heartBeatExecutor.shutdown();
            }
            if (serverCountInSameJVM.decrementAndGet() == 0) {
                cleanExecutor.shutdown();
                cleanExecutor = null;
            }
        }
        catch (Exception e) {
            this.logger.error("DefaultCommunicationServer shutdown exception, {}", (Object)e.toString());
        }
        if (this.publicExecutor != null) {
            try {
                this.publicExecutor.shutdown();
            }
            catch (Exception e) {
                this.logger.error("DefaultCommunicationServer shutdown exception, {}", (Object)e.toString());
            }
        }
    }

    @Override
    public void registerInvokeHook(InvokeHook invokeHook) {
        this.invokeHook = invokeHook;
    }

    @Override
    public void registerHandler(short requestCode, CommunicationRequestHandler handler, ExecutorService executor) {
        ExecutorService executorService = executor;
        if (executorService == null) {
            executorService = this.publicExecutor;
        }
        Pair<CommunicationRequestHandler, ExecutorService> pair = new Pair<CommunicationRequestHandler, ExecutorService>(handler, executorService);
        this.handlerTable.put(requestCode, pair);
    }

    @Override
    public void registerDefaultHandler(CommunicationRequestHandler handler, ExecutorService exec) {
        if (exec == null) {
            exec = this.publicExecutor;
        }
        this.defaultCommunicationRequestHandler = new Pair<CommunicationRequestHandler, ExecutorService>(handler, exec);
    }

    @Override
    public int localListenPort() {
        return this.port;
    }

    @Override
    public Pair<CommunicationRequestHandler, ExecutorService> getHandlerPair(short requestCode) {
        return (Pair)this.handlerTable.get(requestCode);
    }

    @Override
    public ICommunicationUnit invokeSync(Channel channel, ICommunicationUnit request) throws CommunicationException, InterruptedException {
        return this.invokeSyncImpl(channel, request, this.serverConfig.getInvokeSyncTimeout());
    }

    @Override
    public void invokeAsync(Channel channel, ICommunicationUnit request, InvokeCallback invokeCallback) throws CommunicationException, InterruptedException {
        this.invokeAsyncImpl(channel, request, this.serverConfig.getInvokeAsyncTimeout(), invokeCallback);
    }

    @Override
    public void invokeOneway(Channel channel, ICommunicationUnit request) throws CommunicationTimeoutException, InterruptedException {
        this.invokeOneWayImpl(channel, request, this.serverConfig.getInvokeOneWayTimeout());
    }

    @Override
    public InvokeHook getInvokeHook() {
        return this.invokeHook;
    }

    @Override
    public ExecutorService getCallbackExecutor() {
        return this.publicExecutor;
    }

    @Override
    public ChannelEventListener getDefaultChannelEventListener() {
        return this.defaultChannelEventListener;
    }

    @Override
    protected ChannelWrapper getChannelWrapperByChannel(Channel channel) {
        ChannelWrapper rs = null;
        if (channel != null) {
            rs = (ChannelWrapper)this.channelMap.get(channel);
            if (rs == null) {
                rs = new ChannelWrapper(channel, SystemClock.now());
                String channelAddress = CommunicationUtils.parseChannelAddress(channel);
                String newChannelWrapperString = rs.toString();
                this.logger.info("A new ChannelWrapper instance {} has been created for the unregistered channel {}", (Object)newChannelWrapperString, (Object)channelAddress);
            }
        } else {
            this.logger.warn("The provided Channel instance parameter is null!");
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCloseChannel(Channel channel, ChannelFutureListener channelFutureListener) {
        DefaultCommunicationServer defaultCommunicationServer = this;
        synchronized (defaultCommunicationServer) {
            if (channelFutureListener != null) {
                channel.close().addListener((GenericFutureListener)channelFutureListener);
            } else {
                channel.close();
            }
        }
    }

    public void setDecoder(Class decoderCls) {
        this.decoderCls = decoderCls;
    }

    public void setEncoder(Class encoderCls) {
        this.encoderCls = encoderCls;
    }

    static {
        serverCountInSameJVM = new AtomicInteger(0);
    }

    protected class DefaultServerConnectManageHandler
    extends ChannelDuplexHandler {
        protected DefaultServerConnectManageHandler() {
        }

        public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = CommunicationUtils.parseChannelRemoteAddr(ctx.channel());
            DefaultCommunicationServer.this.logger.info("Communication Server Pipeline: channelRegistered {}", (Object)remoteAddress);
            super.channelRegistered(ctx);
        }

        public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = CommunicationUtils.parseChannelRemoteAddr(ctx.channel());
            DefaultCommunicationServer.this.logger.info("Communication Server Pipeline: channelUnregistered {}", (Object)remoteAddress);
            super.channelUnregistered(ctx);
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = CommunicationUtils.parseChannelRemoteAddr(ctx.channel());
            DefaultCommunicationServer.this.logger.info("Communication Server Pipeline: channelActive {}", (Object)remoteAddress);
            super.channelActive(ctx);
            ChannelWrapper channelWrapper = DefaultCommunicationServer.this.getChannelWrapperByChannel(ctx.channel());
            if (DefaultCommunicationServer.this.getDefaultChannelEventListener() != null || channelWrapper.getChannelEventListener() != null) {
                DefaultCommunicationServer.this.putChannelEvent(new ChannelEvent(ChannelEventType.CONNECT, remoteAddress, channelWrapper));
            }
            DefaultCommunicationServer.this.channelMap.put(channelWrapper.getChannel(), channelWrapper);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = CommunicationUtils.parseChannelRemoteAddr(ctx.channel());
            DefaultCommunicationServer.this.logger.info("Communication Server Pipeline: channelInactive {}", (Object)remoteAddress);
            super.channelInactive(ctx);
            ChannelWrapper channelWrapper = DefaultCommunicationServer.this.getChannelWrapperByChannel(ctx.channel());
            if (DefaultCommunicationServer.this.getDefaultChannelEventListener() != null || channelWrapper.getChannelEventListener() != null) {
                DefaultCommunicationServer.this.putChannelEvent(new ChannelEvent(ChannelEventType.CLOSE, remoteAddress, channelWrapper));
            }
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof IdleStateEvent) {
                IdleStateEvent event = (IdleStateEvent)evt;
                String remoteAddress = CommunicationUtils.parseChannelRemoteAddr(ctx.channel());
                ChannelWrapper channelWrapper = DefaultCommunicationServer.this.getChannelWrapperByChannel(ctx.channel());
                ChannelEventType cet = ChannelEventType.ALL_IDLE;
                if (event.state().equals((Object)IdleState.ALL_IDLE)) {
                    DefaultCommunicationServer.this.logger.info("Communication Server Pipeline: ALL_IDLE idle state event {}", (Object)remoteAddress);
                    cet = ChannelEventType.ALL_IDLE;
                } else if (event.state().equals((Object)IdleState.READER_IDLE)) {
                    DefaultCommunicationServer.this.logger.info("Communication Server Pipeline: READER_IDLE idle state event {}", (Object)remoteAddress);
                    cet = ChannelEventType.READ_IDLE;
                } else if (event.state().equals((Object)IdleState.WRITER_IDLE)) {
                    DefaultCommunicationServer.this.logger.info("Communication Server Pipeline: WRITER_IDLE idle state event {}", (Object)remoteAddress);
                    cet = ChannelEventType.WRITE_IDLE;
                }
                if (DefaultCommunicationServer.this.getDefaultChannelEventListener() != null || channelWrapper.getChannelEventListener() != null) {
                    DefaultCommunicationServer.this.putChannelEvent(new ChannelEvent(cet, remoteAddress, channelWrapper));
                }
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            final String remoteAddress = CommunicationUtils.parseChannelRemoteAddr(ctx.channel());
            DefaultCommunicationServer.this.logger.info("Communication Server Pipeline: exceptionCaught {}", (Object)remoteAddress);
            DefaultCommunicationServer.this.logger.info("Communication Server Pipeline: exceptionCaught exception", cause);
            ChannelWrapper channelWrapper = DefaultCommunicationServer.this.getChannelWrapperByChannel(ctx.channel());
            if (DefaultCommunicationServer.this.getDefaultChannelEventListener() != null || channelWrapper.getChannelEventListener() != null) {
                DefaultCommunicationServer.this.putChannelEvent(new ChannelEvent(ChannelEventType.EXCEPTION, remoteAddress, channelWrapper));
            }
            DefaultCommunicationServer.this.doCloseChannel(ctx.channel(), new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    DefaultCommunicationServer.this.logger.info("closeChannel: close the connection to remote address[{}] result: {}", (Object)remoteAddress, (Object)future.isSuccess());
                }
            });
        }
    }

    protected class DefaultHeartBeatHandler
    implements CommunicationRequestHandler {
        protected DefaultHeartBeatHandler() {
        }

        @Override
        public ICommunicationUnit processRequest(ChannelWrapper cw, ICommunicationUnit cu) throws Exception {
            String channelAddress = CommunicationUtils.parseChannelRemoteAddr(cw.getChannel());
            if (DefaultCommunicationServer.this.logger.isDebugEnabled()) {
                DefaultCommunicationServer.this.logger.debug("Received heart beat at the time {}, from the remote address {}", (Object)SystemClock.now(), (Object)channelAddress);
            }
            CommunicationUnit rs = null;
            CommunicationType responseCommunicationType = CommunicationType.getResponseByRequest(cu.getCommunicationType());
            if (responseCommunicationType != CommunicationType.ONE_WAY_RESPONSE) {
                rs = CommunicationUnitUtils.createResponseCommunicationUnit(cu.getRequestNumber(), cu.getCode(), responseCommunicationType);
            }
            return rs;
        }

        @Override
        public boolean rejectRequest() {
            return false;
        }
    }

    protected class ScanChannelMapTask
    implements Runnable {
        protected ScanChannelMapTask() {
        }

        @Override
        public void run() {
            for (Map.Entry entry : DefaultCommunicationServer.this.channelMap.entrySet()) {
                if (((ChannelWrapper)entry.getValue()).isChannelActive()) continue;
                DefaultCommunicationServer.this.channelMap.remove(entry.getKey());
            }
        }
    }
}

