/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.communication.core;

import com.jcloud.jcq.common.utils.CommunicationUtils;
import com.jcloud.jcq.communication.core.ChannelWrapper;
import com.jcloud.jcq.communication.portal.ChannelEventListener;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultChannelEventListener
implements ChannelEventListener {
    private static final String LOG_TEMPLATE = "{} class instance's method {} runs with parameters {} and {}";
    private static final Logger logger = LoggerFactory.getLogger((String)"JcqCommunication");

    @Override
    public void onChannelConnect(String remoteAddr, ChannelWrapper channelWrapper) {
        String channelWrapperString = channelWrapper.toString();
        logger.info(LOG_TEMPLATE, new Object[]{DefaultChannelEventListener.class.getName(), "onChannelConnect()", remoteAddr, channelWrapperString});
    }

    @Override
    public void onChannelClose(String remoteAddr, ChannelWrapper channelWrapper) {
        String channelWrapperString = channelWrapper.toString();
        logger.info(LOG_TEMPLATE, new Object[]{DefaultChannelEventListener.class.getName(), "onChannelClose()", remoteAddr, channelWrapperString});
    }

    @Override
    public void onChannelException(String remoteAddr, ChannelWrapper channelWrapper) {
        String channelWrapperString = channelWrapper.toString();
        logger.info(LOG_TEMPLATE, new Object[]{DefaultChannelEventListener.class.getName(), "onChannelException()", remoteAddr, channelWrapperString});
    }

    @Override
    public void onChannelAllIdle(String remoteAddr, final ChannelWrapper channelWrapper) {
        String channelWrapperString = channelWrapper.toString();
        channelWrapper.shutdownHeartbeatService();
        channelWrapper.getChannel().close().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                logger.info("closeChannel: close the connection to remote address[{}] in DefaultChannelEventListener instance, result: {}", (Object)CommunicationUtils.parseChannelRemoteAddr(channelWrapper.getChannel()), (Object)future.isSuccess());
            }
        });
        logger.info(LOG_TEMPLATE, new Object[]{DefaultChannelEventListener.class.getName(), "onChannelAllIdle()", remoteAddr, channelWrapperString});
    }

    @Override
    public void onChannelReadIdle(String remoteAddr, ChannelWrapper channelWrapper) {
        String channelWrapperString = channelWrapper.toString();
        logger.info(LOG_TEMPLATE, new Object[]{DefaultChannelEventListener.class.getName(), "onChannelReadIdle()", remoteAddr, channelWrapperString});
    }

    @Override
    public void onChannelWriteIdle(String remoteAddr, ChannelWrapper channelWrapper) {
        String channelWrapperString = channelWrapper.toString();
        logger.info(LOG_TEMPLATE, new Object[]{DefaultChannelEventListener.class.getName(), "onChannelWriteIdle()", remoteAddr, channelWrapperString});
    }
}

