/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.communication.core;

import java.util.Properties;

public class CommunicationSystemConfig {
    public static final String SOCKET_SND_BUFFER_SIZE = "communication.snd.buffer.size";
    public static final String SOCKET_RCV_BUFFER_SIZE = "communication.rcv.buffer.size";
    public static final String MAX_FRAME_LENGTH = "communication.frame.max.length";
    public static final String HEART_BEAT_MAX_RETRY_TIMES = "communication.heart.beat.max.retry.times";
    public static final String CLOSE_CHANNEL_IF_ENCODE_ERROR = "communication.close.channel.if.encode.error";
    public static final String CLOSE_CHANNEL_IF_DECODE_ERROR = "communication.close.channel.if.decode.error";
    public static final String JCQ_COMMUNICATION = "JcqCommunication";
    public static final String ENCODER_HANDLER_NAME = "Encoder";
    public static final String DECODER_HANDLER_NAME = "Decoder";
    public static final String IDLE_STATE_HANDLER_NAME = "IdleStateHandler";
    public static final String CONNECT_MANAGE_HANDLER_NAME = "ConnectManageHandler";
    public static final String MESSAGE_HANDLER_NAME = "MessageHandler";
    public static int heartBeatMaxRetryTimes = Integer.parseInt(System.getProperty("communication.heart.beat.max.retry.times", "3"));
    public static int socketSendBufferSize = Integer.parseInt(System.getProperty("communication.snd.buffer.size", "65535"));
    public static int socketRecvBufferSize = Integer.parseInt(System.getProperty("communication.rcv.buffer.size", "65535"));
    public static int frameMaxLength = Integer.parseInt(System.getProperty("communication.frame.max.length", "16777472"));
    public static boolean closeChannelIfDecodeError = System.getProperty("communication.close.channel.if.decode.error", "true").equalsIgnoreCase("true") || System.getProperty("communication.close.channel.if.decode.error", "true").equalsIgnoreCase("1");
    public static boolean closeChannelIfEncodeError = System.getProperty("communication.close.channel.if.encode.error", "true").equalsIgnoreCase("true") || System.getProperty("communication.close.channel.if.encode.error", "true").equalsIgnoreCase("1");

    public static void updateCommunicationSystemConfig(Properties properties) {
        if (properties.containsKey(HEART_BEAT_MAX_RETRY_TIMES)) {
            heartBeatMaxRetryTimes = Integer.parseInt(properties.getProperty(HEART_BEAT_MAX_RETRY_TIMES));
        }
        if (properties.containsKey(MAX_FRAME_LENGTH)) {
            frameMaxLength = Integer.parseInt(properties.getProperty(MAX_FRAME_LENGTH));
        }
        if (properties.containsKey(SOCKET_SND_BUFFER_SIZE)) {
            socketSendBufferSize = Integer.parseInt(properties.getProperty(SOCKET_SND_BUFFER_SIZE));
        }
        if (properties.containsKey(SOCKET_RCV_BUFFER_SIZE)) {
            socketRecvBufferSize = Integer.parseInt(properties.getProperty(SOCKET_RCV_BUFFER_SIZE));
        }
        if (properties.containsKey(CLOSE_CHANNEL_IF_DECODE_ERROR)) {
            boolean bl = closeChannelIfDecodeError = properties.getProperty(CLOSE_CHANNEL_IF_DECODE_ERROR).equalsIgnoreCase("true") || properties.getProperty(CLOSE_CHANNEL_IF_DECODE_ERROR).equalsIgnoreCase("1");
        }
        if (properties.containsKey(CLOSE_CHANNEL_IF_ENCODE_ERROR)) {
            closeChannelIfEncodeError = properties.getProperty(CLOSE_CHANNEL_IF_ENCODE_ERROR).equalsIgnoreCase("true") || properties.getProperty(CLOSE_CHANNEL_IF_ENCODE_ERROR).equalsIgnoreCase("1");
        }
    }

    private CommunicationSystemConfig() {
    }
}

