/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.communication.core;

import com.jcloud.jcq.common.Environment;
import com.jcloud.jcq.communication.core.CommunicationSystemConfig;
import java.util.Properties;

public class CommunicationServerConfig {
    public static final String SERVER_LISTEN_PORT = "communication.server.listen.port";
    public static final String SERVER_WORKER_THREADS = "communication.server.worker.threads";
    public static final String SERVER_CALL_BACK_EXECUTOR_THREADS = "communication.server.callback.executor.threads";
    public static final String SERVER_CHANNEL_CLEAN_WORKER_THREADS = "communication.server.channel.clean.worker.threads";
    public static final String SERVER_BOSS_THREADS = "communication.server.boss.threads";
    public static final String SERVER_SELECTOR_THREADS = "communication.server.selector.threads";
    public static final String SERVER_MAX_ASYNC_INVOCATION = "communication.server.max.async.invocation";
    public static final String SERVER_MAX_ONEWAY_INVOCATION = "communication.server.max.oneway.invocation";
    public static final String SERVER_CHANNEL_MAX_IDLE_TIME_SECONDS = "communication.server.max.idle.time.seconds";
    public static final String SERVER_CHANNEL_MAX_READ_IDLE_TIME_SECONDS = "communication.server.max.read.idle.time.seconds";
    public static final String SERVER_CHANNEL_MAX_WRITE_IDLE_TIME_SECONDS = "communication.server.max.write.idle.time.seconds";
    public static final String SERVER_SYNC_INVOCATION_TIMEOUT = "communication.server.sync.invocation.timeout.milliseconds";
    public static final String SERVER_ASYNC_INVOCATION_TIMEOUT = "communication.server.async.invocation.timeout.milliseconds";
    public static final String SERVER_ONEWAY_INVOCATION_TIMEOUT = "communication.server.oneway.invocation.timeout.milliseconds";
    public static final String SERVER_POOLED_BYTE_BUFFER_ALLOCATOR = "communication.server.pooled.byte.buffer.allocator.enable";
    public static final String SERVER_SOCKET_SEND_BUFFER_SIZE = "communication.server.socket.send.buffer.size";
    public static final String SERVER_SOCKET_RCV_BUFFER_SIZE = "communication.server.socket.rcv.buffer.size";
    public static final String SERVER_COMMUNICATIONUNIT_BODY_POOLED_ENABLE = "communication.server.communicationunit.body.pooled.enable";
    private int listenPort = Integer.parseInt(System.getProperty("communication.server.listen.port", System.getProperty("SERVER_LISTEN_PORT", "8888")));
    public static final String SERVER_HEART_BEAT_EXECUTOR_THREADS = "communication.server.heart.beat.executor.threads";
    private int serverWorkerThreads = Environment.getCpuCore();
    private int serverCallbackExecutorThreads = 2;
    private int serverBossThreads = 1;
    private int serverSelectorThreads = 3;
    private int serverChannelCleanWorkerThreads = 1;
    private int serverOneWaySemaphoreValue = 256;
    private int serverAsyncSemaphoreValue = 64;
    private int serverChannelMaxIdleTimeSeconds = 120;
    private int serverChannelReadIdleTimeSeconds = 120;
    private int serverChannelWriteIdleTimeSeconds = 120;
    private long invokeSyncTimeout = 5000L;
    private long invokeAsyncTimeout = 5000L;
    private long invokeOneWayTimeout = 5000L;
    private int serverSocketSndBufSize = CommunicationSystemConfig.socketSendBufferSize;
    private int serverSocketRcvBufSize = CommunicationSystemConfig.socketRecvBufferSize;
    private boolean serverPooledByteBufAllocatorEnable = true;
    private boolean communicationUnitBodyPooled = false;
    private int heartBeatExecutorThreads = 2;

    public int getListenPort() {
        return this.listenPort;
    }

    public void setListenPort(int listenPort) {
        this.listenPort = listenPort;
    }

    public int getServerWorkerThreads() {
        return this.serverWorkerThreads > 0 ? this.serverWorkerThreads : Environment.getCpuCore();
    }

    public void setServerWorkerThreads(int serverWorkerThreads) {
        this.serverWorkerThreads = serverWorkerThreads;
    }

    public int getServerCallbackExecutorThreads() {
        return this.serverCallbackExecutorThreads;
    }

    public void setServerCallbackExecutorThreads(int serverCallbackExecutorThreads) {
        this.serverCallbackExecutorThreads = serverCallbackExecutorThreads;
    }

    public int getServerSelectorThreads() {
        return this.serverSelectorThreads;
    }

    public void setServerSelectorThreads(int serverSelectorThreads) {
        this.serverSelectorThreads = serverSelectorThreads;
    }

    public int getServerOnewaySemaphoreValue() {
        return this.serverOneWaySemaphoreValue;
    }

    public void setServerOneWaySemaphoreValue(int serverOneWaySemaphoreValue) {
        this.serverOneWaySemaphoreValue = serverOneWaySemaphoreValue;
    }

    public int getServerAsyncSemaphoreValue() {
        return this.serverAsyncSemaphoreValue;
    }

    public void setServerAsyncSemaphoreValue(int serverAsyncSemaphoreValue) {
        this.serverAsyncSemaphoreValue = serverAsyncSemaphoreValue;
    }

    public int getServerChannelMaxIdleTimeSeconds() {
        return this.serverChannelMaxIdleTimeSeconds;
    }

    public void setServerChannelMaxIdleTimeSeconds(int serverChannelMaxIdleTimeSeconds) {
        this.serverChannelMaxIdleTimeSeconds = serverChannelMaxIdleTimeSeconds;
    }

    public int getServerSocketSndBufSize() {
        return this.serverSocketSndBufSize;
    }

    public void setServerSocketSndBufSize(int serverSocketSndBufSize) {
        this.serverSocketSndBufSize = serverSocketSndBufSize;
    }

    public int getServerSocketRcvBufSize() {
        return this.serverSocketRcvBufSize;
    }

    public void setServerSocketRcvBufSize(int serverSocketRcvBufSize) {
        this.serverSocketRcvBufSize = serverSocketRcvBufSize;
    }

    public boolean isServerPooledByteBufAllocatorEnable() {
        return this.serverPooledByteBufAllocatorEnable;
    }

    public void setServerPooledByteBufAllocatorEnable(boolean serverPooledByteBufAllocatorEnable) {
        this.serverPooledByteBufAllocatorEnable = serverPooledByteBufAllocatorEnable;
    }

    public int getServerBossThreads() {
        return this.serverBossThreads;
    }

    public void setServerBossThreads(int serverBossThreads) {
        this.serverBossThreads = serverBossThreads;
    }

    public int getServerChannelReadIdleTimeSeconds() {
        return this.serverChannelReadIdleTimeSeconds;
    }

    public void setServerChannelReadIdleTimeSeconds(int serverChannelReadIdleTimeSeconds) {
        this.serverChannelReadIdleTimeSeconds = serverChannelReadIdleTimeSeconds;
    }

    public int getServerChannelWriteIdleTimeSeconds() {
        return this.serverChannelWriteIdleTimeSeconds;
    }

    public void setServerChannelWriteIdleTimeSeconds(int serverChannelWriteIdleTimeSeconds) {
        this.serverChannelWriteIdleTimeSeconds = serverChannelWriteIdleTimeSeconds;
    }

    public int getServerChannelCleanWorkerThreads() {
        return this.serverChannelCleanWorkerThreads;
    }

    public void setServerChannelCleanWorkerThreads(int serverChannelCleanWorkerThreads) {
        this.serverChannelCleanWorkerThreads = serverChannelCleanWorkerThreads;
    }

    public long getInvokeSyncTimeout() {
        return this.invokeSyncTimeout;
    }

    public void setInvokeSyncTimeout(long invokeSyncTimeout) {
        this.invokeSyncTimeout = invokeSyncTimeout;
    }

    public long getInvokeAsyncTimeout() {
        return this.invokeAsyncTimeout;
    }

    public void setInvokeAsyncTimeout(long invokeAsyncTimeout) {
        this.invokeAsyncTimeout = invokeAsyncTimeout;
    }

    public long getInvokeOneWayTimeout() {
        return this.invokeOneWayTimeout;
    }

    public void setInvokeOneWayTimeout(long invokeOneWayTimeout) {
        this.invokeOneWayTimeout = invokeOneWayTimeout;
    }

    public boolean isCommunicationUnitBodyPooled() {
        return this.communicationUnitBodyPooled;
    }

    public void setCommunicationUnitBodyPooled(boolean communicationUnitBodyPooled) {
        this.communicationUnitBodyPooled = communicationUnitBodyPooled;
    }

    public int getHeartBeatExecutorThreads() {
        return this.heartBeatExecutorThreads;
    }

    public void setHeartBeatExecutorThreads(int heartBeatExecutorThreads) {
        this.heartBeatExecutorThreads = heartBeatExecutorThreads;
    }

    public CommunicationServerConfig() {
    }

    public CommunicationServerConfig(Properties properties) {
        String property;
        if (properties.containsKey(SERVER_LISTEN_PORT)) {
            this.setListenPort(Integer.parseInt(properties.getProperty(SERVER_LISTEN_PORT)));
        }
        if (properties.containsKey(SERVER_WORKER_THREADS)) {
            this.setServerWorkerThreads(Integer.parseInt(properties.getProperty(SERVER_WORKER_THREADS)));
        }
        if (properties.containsKey(SERVER_CALL_BACK_EXECUTOR_THREADS)) {
            this.setServerCallbackExecutorThreads(Integer.parseInt(properties.getProperty(SERVER_CALL_BACK_EXECUTOR_THREADS)));
        }
        if (properties.containsKey(SERVER_BOSS_THREADS)) {
            this.setServerBossThreads(Integer.parseInt(properties.getProperty(SERVER_BOSS_THREADS)));
        }
        if (properties.containsKey(SERVER_SELECTOR_THREADS)) {
            this.setServerSelectorThreads(Integer.parseInt(properties.getProperty(SERVER_SELECTOR_THREADS)));
        }
        if (properties.containsKey(SERVER_CHANNEL_CLEAN_WORKER_THREADS)) {
            this.setServerChannelCleanWorkerThreads(Integer.parseInt(properties.getProperty(SERVER_CHANNEL_CLEAN_WORKER_THREADS)));
        }
        if (properties.containsKey(SERVER_MAX_ASYNC_INVOCATION)) {
            this.setServerAsyncSemaphoreValue(Integer.parseInt(properties.getProperty(SERVER_MAX_ASYNC_INVOCATION)));
        }
        if (properties.containsKey(SERVER_MAX_ONEWAY_INVOCATION)) {
            this.setServerOneWaySemaphoreValue(Integer.parseInt(properties.getProperty(SERVER_MAX_ONEWAY_INVOCATION)));
        }
        if (properties.containsKey(SERVER_CHANNEL_MAX_IDLE_TIME_SECONDS)) {
            this.setServerChannelMaxIdleTimeSeconds(Integer.parseInt(properties.getProperty(SERVER_CHANNEL_MAX_IDLE_TIME_SECONDS)));
        }
        if (properties.containsKey(SERVER_CHANNEL_MAX_READ_IDLE_TIME_SECONDS)) {
            this.setServerChannelReadIdleTimeSeconds(Integer.parseInt(properties.getProperty(SERVER_CHANNEL_MAX_READ_IDLE_TIME_SECONDS)));
        }
        if (properties.containsKey(SERVER_CHANNEL_MAX_WRITE_IDLE_TIME_SECONDS)) {
            this.setServerChannelWriteIdleTimeSeconds(Integer.parseInt(properties.getProperty(SERVER_CHANNEL_MAX_WRITE_IDLE_TIME_SECONDS)));
        }
        if (properties.containsKey(SERVER_SYNC_INVOCATION_TIMEOUT)) {
            this.setInvokeSyncTimeout(Long.parseLong(properties.getProperty(SERVER_SYNC_INVOCATION_TIMEOUT)));
        }
        if (properties.containsKey(SERVER_ASYNC_INVOCATION_TIMEOUT)) {
            this.setInvokeAsyncTimeout(Long.parseLong(properties.getProperty(SERVER_ASYNC_INVOCATION_TIMEOUT)));
        }
        if (properties.containsKey(SERVER_ONEWAY_INVOCATION_TIMEOUT)) {
            this.setInvokeOneWayTimeout(Long.parseLong(properties.getProperty(SERVER_ONEWAY_INVOCATION_TIMEOUT)));
        }
        if (properties.containsKey(SERVER_SOCKET_SEND_BUFFER_SIZE)) {
            this.setServerSocketSndBufSize(Integer.parseInt(properties.getProperty(SERVER_SOCKET_SEND_BUFFER_SIZE)));
        }
        if (properties.containsKey(SERVER_SOCKET_RCV_BUFFER_SIZE)) {
            this.setServerSocketRcvBufSize(Integer.parseInt(properties.getProperty(SERVER_SOCKET_RCV_BUFFER_SIZE)));
        }
        if (properties.containsKey(SERVER_POOLED_BYTE_BUFFER_ALLOCATOR)) {
            property = properties.getProperty(SERVER_POOLED_BYTE_BUFFER_ALLOCATOR);
            this.setServerPooledByteBufAllocatorEnable("true".equalsIgnoreCase(property) || "1".equalsIgnoreCase(property));
        }
        if (properties.containsKey(SERVER_COMMUNICATIONUNIT_BODY_POOLED_ENABLE)) {
            property = properties.getProperty(SERVER_COMMUNICATIONUNIT_BODY_POOLED_ENABLE);
            this.setCommunicationUnitBodyPooled("true".equalsIgnoreCase(property) || "1".equalsIgnoreCase(property));
        }
        if (properties.containsKey(SERVER_HEART_BEAT_EXECUTOR_THREADS)) {
            this.setHeartBeatExecutorThreads(Integer.parseInt(properties.getProperty(SERVER_HEART_BEAT_EXECUTOR_THREADS)));
        }
    }
}

