/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.communication.core;

import com.jcloud.jcq.common.Environment;
import com.jcloud.jcq.communication.core.CommunicationSystemConfig;
import java.util.Properties;

public class CommunicationClientConfig {
    public static final String CLIENT_EVENT_WORKER_THREADS = "communication.client.event.loop.worker.threads";
    public static final String CLIENT_WORKER_THREADS = "communication.client.worker.threads";
    public static final String CLIENT_CHANNEL_HEART_BEAT_WORKER_THREADS = "communication.client.channel.heartbeat.worker.threads";
    public static final String CLIENT_CHANNEL_CLEAN_WORKER_THREADS = "communication.client.channel.clean.worker.threads";
    public static final String CLIENT_CALL_BACK_THREADS = "communication.client.worker.callback.threads";
    public static final String CLIENT_MAX_ASYNC_INVOCATION = "communication.client.max.async.invocation";
    public static final String CLIENT_MAX_ONEWAY_INVOCATION = "communication.client.max.oneway.invocation";
    public static final String CLIENT_CONNECT_TIMEOUT = "communication.client.connect.timeout.milliseconds";
    public static final String CLIENT_CHANNEL_MAX_IDLE_TIME_SECONDS = "communication.client.max.idle.time.seconds";
    public static final String CLIENT_CHANNEL_MAX_READ_IDLE_TIME_SECONDS = "communication.client.max.read.idle.time.seconds";
    public static final String CLIENT_CHANNEL_MAX_WRITE_IDLE_TIME_SECONDS = "communication.client.max.write.idle.time.seconds";
    public static final String CLIENT_SYNC_INVOCATION_TIMEOUT = "communication.client.sync.invocation.timeout.milliseconds";
    public static final String CLIENT_ASYNC_INVOCATION_TIMEOUT = "communication.client.async.invocation.timeout.milliseconds";
    public static final String CLIENT_ONEWAY_INVOCATION_TIMEOUT = "communication.client.oneway.invocation.timeout.milliseconds";
    public static final String CLIENT_SOCKET_SEND_BUFFER_SIZE = "communication.client.socket.send.buffer.size";
    public static final String CLIENT_SOCKET_RCV_BUFFER_SIZE = "communication.client.socket.rcv.buffer.size";
    public static final String CLIENT_CLOSE_CHANNEL_AFTER_EXCEPTION = "communication.client.close.channel.after.exception";
    public static final String CLIENT_USE_EPOLL = "communication.client.use.epoll";
    private boolean closeChannelAfterInvocationException = false;
    private int clientEventLoopWorkerThreads = 1;
    private int clientWorkerThreads = 4;
    private int clientChannelHeartBeatWorkerThreads = 4;
    private int clientChannelCleanWorkerThreads = 1;
    private int clientCallbackExecutorThreads = Environment.getCpuCore();
    private int clientOneWaySemaphoreValue = 256;
    private int clientAsyncSemaphoreValue = 64;
    private int connectTimeoutMillis = 3000;
    private int clientChannelMaxIdleTimeSeconds = 120;
    private int clientChannelReadIdleTimeSeconds = 120;
    private int clientChannelWriteIdleTimeSeconds = 120;
    private long invokeSyncTimeout = 5000L;
    private long invokeAsyncTimeout = 5000L;
    private long invokeOneWayTimeout = 5000L;
    private int clientSocketSndBufSize = CommunicationSystemConfig.socketSendBufferSize;
    private int clientSocketRcvBufSize = CommunicationSystemConfig.socketRecvBufferSize;
    private boolean useEpoll = true;

    public int getClientWorkerThreads() {
        return this.clientWorkerThreads;
    }

    public void setClientWorkerThreads(int clientWorkerThreads) {
        this.clientWorkerThreads = clientWorkerThreads;
    }

    public int getClientCallbackExecutorThreads() {
        return this.clientCallbackExecutorThreads;
    }

    public void setClientCallbackExecutorThreads(int clientCallbackExecutorThreads) {
        this.clientCallbackExecutorThreads = clientCallbackExecutorThreads;
    }

    public int getClientOneWaySemaphoreValue() {
        return this.clientOneWaySemaphoreValue;
    }

    public void setClientOneWaySemaphoreValue(int clientOneWaySemaphoreValue) {
        this.clientOneWaySemaphoreValue = clientOneWaySemaphoreValue;
    }

    public int getClientAsyncSemaphoreValue() {
        return this.clientAsyncSemaphoreValue;
    }

    public void setClientAsyncSemaphoreValue(int clientAsyncSemaphoreValue) {
        this.clientAsyncSemaphoreValue = clientAsyncSemaphoreValue;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public void setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    public int getClientChannelMaxIdleTimeSeconds() {
        return this.clientChannelMaxIdleTimeSeconds;
    }

    public void setClientChannelMaxIdleTimeSeconds(int clientChannelMaxIdleTimeSeconds) {
        this.clientChannelMaxIdleTimeSeconds = clientChannelMaxIdleTimeSeconds;
    }

    public int getClientChannelReadIdleTimeSeconds() {
        return this.clientChannelReadIdleTimeSeconds;
    }

    public void setClientChannelReadIdleTimeSeconds(int clientChannelReadIdleTimeSeconds) {
        this.clientChannelReadIdleTimeSeconds = clientChannelReadIdleTimeSeconds;
    }

    public int getClientChannelWriteIdleTimeSeconds() {
        return this.clientChannelWriteIdleTimeSeconds;
    }

    public void setClientChannelWriteIdleTimeSeconds(int clientChannelWriteIdleTimeSeconds) {
        this.clientChannelWriteIdleTimeSeconds = clientChannelWriteIdleTimeSeconds;
    }

    public long getInvokeSyncTimeout() {
        return this.invokeSyncTimeout;
    }

    public void setInvokeSyncTimeout(long invokeSyncTimeout) {
        this.invokeSyncTimeout = invokeSyncTimeout;
    }

    public long getInvokeAsyncTimeout() {
        return this.invokeAsyncTimeout;
    }

    public void setInvokeAsyncTimeout(long invokeAsyncTimeout) {
        this.invokeAsyncTimeout = invokeAsyncTimeout;
    }

    public long getInvokeOneWayTimeout() {
        return this.invokeOneWayTimeout;
    }

    public void setInvokeOneWayTimeout(long invokeOneWayTimeout) {
        this.invokeOneWayTimeout = invokeOneWayTimeout;
    }

    public int getClientSocketSndBufSize() {
        return this.clientSocketSndBufSize;
    }

    public void setClientSocketSndBufSize(int clientSocketSndBufSize) {
        this.clientSocketSndBufSize = clientSocketSndBufSize;
    }

    public int getClientSocketRcvBufSize() {
        return this.clientSocketRcvBufSize;
    }

    public void setClientSocketRcvBufSize(int clientSocketRcvBufSize) {
        this.clientSocketRcvBufSize = clientSocketRcvBufSize;
    }

    public int getClientEventLoopWorkerThreads() {
        return this.clientEventLoopWorkerThreads;
    }

    public void setClientEventLoopWorkerThreads(int clientEventLoopWorkerThreads) {
        this.clientEventLoopWorkerThreads = clientEventLoopWorkerThreads;
    }

    public int getClientChannelHeartBeatWorkerThreads() {
        return this.clientChannelHeartBeatWorkerThreads;
    }

    public void setClientChannelHeartBeatWorkerThreads(int clientChannelHeartBeatWorkerThreads) {
        this.clientChannelHeartBeatWorkerThreads = clientChannelHeartBeatWorkerThreads;
    }

    public boolean getCloseChannelAfterInvocationException() {
        return this.closeChannelAfterInvocationException;
    }

    public void setCloseChannelAfterInvocationException(boolean closeChannelAfterInvocationException) {
        this.closeChannelAfterInvocationException = closeChannelAfterInvocationException;
    }

    public int getClientChannelCleanWorkerThreads() {
        return this.clientChannelCleanWorkerThreads;
    }

    public void setClientChannelCleanWorkerThreads(int clientChannelCleanWorkerThreads) {
        this.clientChannelCleanWorkerThreads = clientChannelCleanWorkerThreads;
    }

    public boolean isUseEpoll() {
        return this.useEpoll;
    }

    public void setUseEpoll(boolean useEpoll) {
        this.useEpoll = useEpoll;
    }

    private String getPropertyFromSystem(String propertyName) {
        return System.getProperty(propertyName, System.getenv(propertyName));
    }

    public CommunicationClientConfig() {
        if (this.getPropertyFromSystem(CLIENT_EVENT_WORKER_THREADS) != null) {
            this.setClientEventLoopWorkerThreads(Integer.parseInt(this.getPropertyFromSystem(CLIENT_EVENT_WORKER_THREADS)));
        }
        if (this.getPropertyFromSystem(CLIENT_WORKER_THREADS) != null) {
            this.setClientWorkerThreads(Integer.parseInt(this.getPropertyFromSystem(CLIENT_WORKER_THREADS)));
        }
        if (this.getPropertyFromSystem(CLIENT_CHANNEL_HEART_BEAT_WORKER_THREADS) != null) {
            this.setClientChannelHeartBeatWorkerThreads(Integer.parseInt(this.getPropertyFromSystem(CLIENT_CHANNEL_HEART_BEAT_WORKER_THREADS)));
        }
        if (this.getPropertyFromSystem(CLIENT_CALL_BACK_THREADS) != null) {
            this.setClientCallbackExecutorThreads(Integer.parseInt(this.getPropertyFromSystem(CLIENT_CALL_BACK_THREADS)));
        }
        if (this.getPropertyFromSystem(CLIENT_MAX_ASYNC_INVOCATION) != null) {
            this.setClientAsyncSemaphoreValue(Integer.parseInt(this.getPropertyFromSystem(CLIENT_MAX_ASYNC_INVOCATION)));
        }
        if (this.getPropertyFromSystem(CLIENT_MAX_ONEWAY_INVOCATION) != null) {
            this.setClientOneWaySemaphoreValue(Integer.parseInt(this.getPropertyFromSystem(CLIENT_MAX_ONEWAY_INVOCATION)));
        }
        if (this.getPropertyFromSystem(CLIENT_CONNECT_TIMEOUT) != null) {
            this.setConnectTimeoutMillis(Integer.parseInt(this.getPropertyFromSystem(CLIENT_CONNECT_TIMEOUT)));
        }
        if (this.getPropertyFromSystem(CLIENT_CHANNEL_MAX_IDLE_TIME_SECONDS) != null) {
            this.setClientChannelMaxIdleTimeSeconds(Integer.parseInt(this.getPropertyFromSystem(CLIENT_CHANNEL_MAX_IDLE_TIME_SECONDS)));
        }
        if (this.getPropertyFromSystem(CLIENT_CHANNEL_MAX_READ_IDLE_TIME_SECONDS) != null) {
            this.setClientChannelReadIdleTimeSeconds(Integer.parseInt(this.getPropertyFromSystem(CLIENT_CHANNEL_MAX_READ_IDLE_TIME_SECONDS)));
        }
        if (this.getPropertyFromSystem(CLIENT_CHANNEL_MAX_WRITE_IDLE_TIME_SECONDS) != null) {
            this.setClientChannelWriteIdleTimeSeconds(Integer.parseInt(this.getPropertyFromSystem(CLIENT_CHANNEL_MAX_WRITE_IDLE_TIME_SECONDS)));
        }
        if (this.getPropertyFromSystem(CLIENT_SYNC_INVOCATION_TIMEOUT) != null) {
            this.setInvokeSyncTimeout(Long.parseLong(this.getPropertyFromSystem(CLIENT_SYNC_INVOCATION_TIMEOUT)));
        }
        if (this.getPropertyFromSystem(CLIENT_ASYNC_INVOCATION_TIMEOUT) != null) {
            this.setInvokeAsyncTimeout(Long.parseLong(this.getPropertyFromSystem(CLIENT_ASYNC_INVOCATION_TIMEOUT)));
        }
        if (this.getPropertyFromSystem(CLIENT_ONEWAY_INVOCATION_TIMEOUT) != null) {
            this.setInvokeOneWayTimeout(Long.parseLong(this.getPropertyFromSystem(CLIENT_ONEWAY_INVOCATION_TIMEOUT)));
        }
        if (this.getPropertyFromSystem(CLIENT_SOCKET_SEND_BUFFER_SIZE) != null) {
            this.setClientSocketSndBufSize(Integer.parseInt(this.getPropertyFromSystem(CLIENT_SOCKET_SEND_BUFFER_SIZE)));
        }
        if (this.getPropertyFromSystem(CLIENT_SOCKET_RCV_BUFFER_SIZE) != null) {
            this.setClientSocketRcvBufSize(Integer.parseInt(this.getPropertyFromSystem(CLIENT_SOCKET_RCV_BUFFER_SIZE)));
        }
        if (this.getPropertyFromSystem(CLIENT_CHANNEL_CLEAN_WORKER_THREADS) != null) {
            this.setClientChannelCleanWorkerThreads(Integer.parseInt(this.getPropertyFromSystem(CLIENT_CHANNEL_CLEAN_WORKER_THREADS)));
        }
        if (this.getPropertyFromSystem(CLIENT_CLOSE_CHANNEL_AFTER_EXCEPTION) != null) {
            this.setCloseChannelAfterInvocationException(this.getPropertyFromSystem(CLIENT_CLOSE_CHANNEL_AFTER_EXCEPTION).equalsIgnoreCase("true") || this.getPropertyFromSystem(CLIENT_CLOSE_CHANNEL_AFTER_EXCEPTION).equalsIgnoreCase("1"));
        }
        if (this.getPropertyFromSystem(CLIENT_USE_EPOLL) != null) {
            this.setUseEpoll(Boolean.parseBoolean(this.getPropertyFromSystem(CLIENT_USE_EPOLL)));
        }
    }

    public CommunicationClientConfig(Properties properties) {
        this();
        if (properties.containsKey(CLIENT_EVENT_WORKER_THREADS)) {
            this.setClientEventLoopWorkerThreads(Integer.parseInt(properties.getProperty(CLIENT_EVENT_WORKER_THREADS)));
        }
        if (properties.containsKey(CLIENT_WORKER_THREADS)) {
            this.setClientWorkerThreads(Integer.parseInt(properties.getProperty(CLIENT_WORKER_THREADS)));
        }
        if (properties.containsKey(CLIENT_CHANNEL_HEART_BEAT_WORKER_THREADS)) {
            this.setClientChannelHeartBeatWorkerThreads(Integer.parseInt(properties.getProperty(CLIENT_CHANNEL_HEART_BEAT_WORKER_THREADS)));
        }
        if (properties.containsKey(CLIENT_CALL_BACK_THREADS)) {
            this.setClientCallbackExecutorThreads(Integer.parseInt(properties.getProperty(CLIENT_CALL_BACK_THREADS)));
        }
        if (properties.containsKey(CLIENT_MAX_ASYNC_INVOCATION)) {
            this.setClientAsyncSemaphoreValue(Integer.parseInt(properties.getProperty(CLIENT_MAX_ASYNC_INVOCATION)));
        }
        if (properties.containsKey(CLIENT_MAX_ONEWAY_INVOCATION)) {
            this.setClientOneWaySemaphoreValue(Integer.parseInt(properties.getProperty(CLIENT_MAX_ONEWAY_INVOCATION)));
        }
        if (properties.containsKey(CLIENT_CONNECT_TIMEOUT)) {
            this.setConnectTimeoutMillis(Integer.parseInt(properties.getProperty(CLIENT_CONNECT_TIMEOUT)));
        }
        if (properties.containsKey(CLIENT_CHANNEL_MAX_IDLE_TIME_SECONDS)) {
            this.setClientChannelMaxIdleTimeSeconds(Integer.parseInt(properties.getProperty(CLIENT_CHANNEL_MAX_IDLE_TIME_SECONDS)));
        }
        if (properties.containsKey(CLIENT_CHANNEL_MAX_READ_IDLE_TIME_SECONDS)) {
            this.setClientChannelReadIdleTimeSeconds(Integer.parseInt(properties.getProperty(CLIENT_CHANNEL_MAX_READ_IDLE_TIME_SECONDS)));
        }
        if (properties.containsKey(CLIENT_CHANNEL_MAX_WRITE_IDLE_TIME_SECONDS)) {
            this.setClientChannelWriteIdleTimeSeconds(Integer.parseInt(properties.getProperty(CLIENT_CHANNEL_MAX_WRITE_IDLE_TIME_SECONDS)));
        }
        if (properties.containsKey(CLIENT_SYNC_INVOCATION_TIMEOUT)) {
            this.setInvokeSyncTimeout(Long.parseLong(properties.getProperty(CLIENT_SYNC_INVOCATION_TIMEOUT)));
        }
        if (properties.containsKey(CLIENT_ASYNC_INVOCATION_TIMEOUT)) {
            this.setInvokeAsyncTimeout(Long.parseLong(properties.getProperty(CLIENT_ASYNC_INVOCATION_TIMEOUT)));
        }
        if (properties.containsKey(CLIENT_ONEWAY_INVOCATION_TIMEOUT)) {
            this.setInvokeOneWayTimeout(Long.parseLong(properties.getProperty(CLIENT_ONEWAY_INVOCATION_TIMEOUT)));
        }
        if (properties.containsKey(CLIENT_SOCKET_SEND_BUFFER_SIZE)) {
            this.setClientSocketSndBufSize(Integer.parseInt(properties.getProperty(CLIENT_SOCKET_SEND_BUFFER_SIZE)));
        }
        if (properties.containsKey(CLIENT_SOCKET_RCV_BUFFER_SIZE)) {
            this.setClientSocketRcvBufSize(Integer.parseInt(properties.getProperty(CLIENT_SOCKET_RCV_BUFFER_SIZE)));
        }
        if (properties.containsKey(CLIENT_CLOSE_CHANNEL_AFTER_EXCEPTION)) {
            this.setCloseChannelAfterInvocationException(properties.getProperty(CLIENT_CLOSE_CHANNEL_AFTER_EXCEPTION).equalsIgnoreCase("true") || properties.getProperty(CLIENT_CLOSE_CHANNEL_AFTER_EXCEPTION).equalsIgnoreCase("1"));
        }
        if (properties.containsKey(CLIENT_CHANNEL_CLEAN_WORKER_THREADS)) {
            this.setClientChannelCleanWorkerThreads(Integer.parseInt(properties.getProperty(CLIENT_CHANNEL_CLEAN_WORKER_THREADS)));
        }
    }
}

