/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.communication.core;

import com.jcloud.jcq.common.utils.CommunicationUtils;
import com.jcloud.jcq.common.utils.StringBuilderWrapper;
import com.jcloud.jcq.common.utils.StringUtils;
import com.jcloud.jcq.common.utils.ThreadLocalStringBuilderUtils;
import com.jcloud.jcq.communication.core.CommunicationSystemConfig;
import com.jcloud.jcq.communication.core.ResponseFuture;
import com.jcloud.jcq.communication.portal.ChannelEventListener;
import com.jcloud.jcq.communication.protocol.CommunicationUnit;
import com.jcloud.jcq.communication.protocol.CommunicationUnitUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.HashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelWrapper {
    private static final Logger logger = LoggerFactory.getLogger((String)"JcqCommunication");
    private volatile Channel channel;
    private volatile long creationTimeStamp;
    private ScheduledThreadPoolExecutor scheduledHeartBeatExecutor;
    private Runnable heartBeatRunnable;
    private ChannelEventListener channelEventListener;
    private AtomicInteger heartbeatFailureTimes = new AtomicInteger(0);
    private ConcurrentMap<Integer, ResponseFuture> responseTable;
    private ScheduledFuture<?> scheduledFuture;

    public ChannelWrapper(Channel channel, long creationTimeStamp) {
        this.channel = channel;
        this.creationTimeStamp = creationTimeStamp;
        this.scheduledHeartBeatExecutor = null;
    }

    public ChannelWrapper(Channel channel, long creationTimeStamp, ScheduledThreadPoolExecutor scheduledHeartBeatExecutor, ConcurrentMap<Integer, ResponseFuture> responseTable) {
        this.channel = channel;
        this.creationTimeStamp = creationTimeStamp;
        this.scheduledHeartBeatExecutor = scheduledHeartBeatExecutor;
        this.responseTable = responseTable;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public long getCreationTimeStamp() {
        return this.creationTimeStamp;
    }

    public ChannelEventListener getChannelEventListener() {
        return this.channelEventListener;
    }

    public void setChannelEventListener(ChannelEventListener channelEventListener) {
        this.channelEventListener = channelEventListener;
    }

    public boolean isChannelActive() {
        return this.getChannel() != null && this.getChannel().isActive();
    }

    public boolean isChannelWritable() {
        return this.getChannel().isWritable();
    }

    public boolean startHeartbeatService() {
        boolean rs = false;
        if (this.scheduledHeartBeatExecutor != null && this.getChannel() != null) {
            String channelString = CommunicationUtils.parseChannelAddress(this.getChannel());
            this.heartBeatRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        if (ChannelWrapper.this.channel == null || !ChannelWrapper.this.channel.isActive()) {
                            return;
                        }
                        CommunicationUnit request = CommunicationUnitUtils.createHeartbeatRequestCommunicationUnit();
                        final int requestNumber = request.getRequestNumber();
                        if (ChannelWrapper.this.responseTable != null) {
                            ResponseFuture rf = new ResponseFuture(requestNumber, 3000L, null, null);
                            ChannelWrapper.this.responseTable.put(requestNumber, rf);
                        }
                        ChannelWrapper.this.getChannel().writeAndFlush((Object)request).addListener((GenericFutureListener)new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                                ChannelWrapper.this.handleHeartResponseFuture(requestNumber, channelFuture.isSuccess());
                            }
                        });
                        ChannelWrapper.this.handleHeartResponse(requestNumber);
                        if (ChannelWrapper.this.heartbeatFailureTimes.get() >= CommunicationSystemConfig.heartBeatMaxRetryTimes) {
                            ChannelWrapper.this.getChannel().close();
                        }
                    }
                    catch (Exception e) {
                        logger.warn("heartBeatService exception {} when sending heartbeat to the channel {}", (Object)e, (Object)CommunicationUtils.parseChannelAddress(ChannelWrapper.this.getChannel()));
                    }
                }
            };
            this.scheduledFuture = this.scheduledHeartBeatExecutor.scheduleAtFixedRate(this.heartBeatRunnable, 1000L, 3000L, TimeUnit.MILLISECONDS);
            logger.info("The heart beat service for the channel {} has already been started.", (Object)channelString);
            rs = true;
        }
        return rs;
    }

    private void handleHeartResponse(int requestNumber) {
        if (this.responseTable == null) {
            return;
        }
        ResponseFuture responseFuture = (ResponseFuture)this.responseTable.get(requestNumber);
        if (responseFuture == null) {
            this.heartbeatFailureTimes.incrementAndGet();
            return;
        }
        boolean isSucceeded = false;
        try {
            isSucceeded = responseFuture.isRequestSentSuccessfully() && responseFuture.getResponseUnit() != null;
        }
        catch (InterruptedException e) {
            logger.info("handleHeartResponse exception,requestNumber is {}", (Object)requestNumber, (Object)e);
        }
        if (isSucceeded) {
            this.heartbeatFailureTimes.set(0);
        } else {
            this.heartbeatFailureTimes.incrementAndGet();
        }
        this.responseTable.remove(requestNumber);
    }

    private void handleHeartResponseFuture(int requestNumber, boolean isSucceeded) {
        if (this.responseTable == null) {
            if (isSucceeded) {
                this.heartbeatFailureTimes.set(0);
            } else {
                this.heartbeatFailureTimes.incrementAndGet();
            }
        } else {
            ResponseFuture responseFuture = null;
            responseFuture = (ResponseFuture)this.responseTable.get(requestNumber);
            if (responseFuture != null) {
                responseFuture.setRequestSentSuccessfully(isSucceeded);
            }
        }
    }

    public boolean shutdownHeartbeatService() {
        boolean rs = false;
        if (this.scheduledHeartBeatExecutor != null && this.heartBeatRunnable != null) {
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(true);
            }
            String channelString = CommunicationUtils.parseChannelAddress(this.getChannel());
            logger.debug("The heart beat service for the channel {} has already been shutdown.", (Object)channelString);
            rs = true;
        }
        return rs;
    }

    public boolean isHeartbeatServiceRunning() {
        return this.scheduledHeartBeatExecutor != null && this.scheduledHeartBeatExecutor.getActiveCount() > 0;
    }

    public String toString() {
        HashMap<String, String> kvmap = new HashMap<String, String>(4);
        kvmap.put("Channel", this.getChannel().toString());
        kvmap.put("CreationTimestamp", Long.toString(this.getCreationTimeStamp()));
        return StringUtils.toStringHelper(this.getClass().getName(), kvmap);
    }

    public StringBuilderWrapper toStringBuilderWrapper() {
        return ThreadLocalStringBuilderUtils.append(this.getClass().getName()).append("-[").append("Channel=").append(this.getChannel().toString()).append(",CreationTimestamp=").append(Long.toString(this.getCreationTimeStamp())).append("]");
    }

    public boolean equals(Object object) {
        boolean rs = false;
        if (object != null && this.getClass() == object.getClass()) {
            ChannelWrapper channelWrapper = (ChannelWrapper)object;
            rs = (this.channel == null ? channelWrapper.getChannel() == null : this.channel.equals(channelWrapper.getChannel())) && this.creationTimeStamp == channelWrapper.getCreationTimeStamp() && (this.channelEventListener == null ? channelWrapper.getChannelEventListener() == null : this.channelEventListener.equals(channelWrapper.getChannelEventListener()));
        }
        return rs;
    }

    public int hashCode() {
        int rs = 0;
        rs += this.channel == null ? 0 : this.channel.hashCode();
        rs = (int)((long)rs + this.creationTimeStamp);
        rs += this.channelEventListener == null ? 0 : this.channelEventListener.hashCode();
        return rs += this.scheduledHeartBeatExecutor == null ? 0 : this.scheduledHeartBeatExecutor.hashCode();
    }
}

