/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.common.version;

import com.jcloud.jcq.common.utils.StringUtils;

public enum JcqVersion {
    NULL("NULL", 0),
    V0_0_1("0.0.1", JcqVersion.get(0, 0, 1)),
    TEST("TEST", JcqVersion.get(0, 1, 0)),
    V1_0_0("1.0.0", JcqVersion.get(1, 0, 0)),
    V1_0_1("1.0.1", JcqVersion.get(1, 0, 1)),
    V1_0_2("1.0.2", JcqVersion.get(1, 0, 2)),
    V1_0_3("1.0.3", JcqVersion.get(1, 0, 3)),
    V2_0_0("2.0.0", JcqVersion.get(2, 0, 0)),
    V2_0_1("2.0.1", JcqVersion.get(2, 0, 1)),
    V9_9_9("9.9.9", JcqVersion.get(9, 9, 9));

    private String version;
    private int value;

    private JcqVersion(String version, int value) {
        this.version = version;
        this.value = value;
    }

    public String getVersion() {
        return this.version;
    }

    public int getValue() {
        return this.value;
    }

    public static JcqVersion transform(String version) {
        if (StringUtils.isEmpty(version)) {
            return NULL;
        }
        switch (version) {
            case "TEST": {
                return TEST;
            }
            case "0.0.1": {
                return V0_0_1;
            }
            case "1.0.0": {
                return V1_0_0;
            }
            case "1.0.1": {
                return V1_0_1;
            }
            case "1.0.2": {
                return V1_0_2;
            }
            case "1.0.3": {
                return V1_0_3;
            }
            case "2.0.0": {
                return V2_0_0;
            }
            case "2.0.1": {
                return V2_0_1;
            }
        }
        if (version.matches("\\d\\.\\d\\.\\d") && version.compareTo("2.0.1") > 0) {
            return V9_9_9;
        }
        return NULL;
    }

    public static short get(int high, int middle, int low) {
        int version = high;
        version = version << 5 | middle;
        version = version << 5 | low;
        return (short)version;
    }
}

