/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.common.utils;

import com.jcloud.jcq.common.thread.ThreadFactoryImpl;
import com.jcloud.jcq.common.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolMonitor {
    private static final Logger logger = LoggerFactory.getLogger(ThreadPoolMonitor.class);
    private static Map<String, ExecutorService> threadNames = new HashMap<String, ExecutorService>();
    private static AtomicBoolean start = new AtomicBoolean(false);
    private static AtomicLong executionCount = new AtomicLong(0L);
    private static final int OUTPUT_SKIP_CNT = 60;
    private static ScheduledFuture scheduledFuture;

    public static void registerThreadPool(String name, ExecutorService executorService) {
        threadNames.put(name, executorService);
    }

    public static void unregisterThreadPool(String name) {
        threadNames.remove(name);
    }

    public static void start() {
        if (start.compareAndSet(false, true)) {
            ScheduledThreadPoolExecutor monitor = new ScheduledThreadPoolExecutor(1, new ThreadFactoryImpl("ThreadPool-monitor-"));
            scheduledFuture = monitor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (threadNames.size() == 0 || !start.get()) {
                        return;
                    }
                    StringBuilder builder = new StringBuilder();
                    for (Map.Entry entry : threadNames.entrySet()) {
                        if (entry.getValue() == null) continue;
                        ThreadPoolExecutor executor = (ThreadPoolExecutor)entry.getValue();
                        if (executor.getQueue().size() >= 2 * executor.getMaximumPoolSize() || executor.isShutdown()) {
                            builder.append("(").append((String)entry.getKey()).append(",").append(executor.getCorePoolSize()).append(",").append(executor.getMaximumPoolSize()).append(",").append(executor.getActiveCount()).append(",").append(executor.getQueue().size()).append(",").append(executor.isShutdown()).append(")");
                        }
                        if (executionCount.get() % 60L != 0L) continue;
                        logger.info("Thread pool name: {}, Queue size:{}, CompletedTaskCount:{}", new Object[]{entry.getKey(), executor.getQueue().size(), executor.getCompletedTaskCount()});
                    }
                    if (!StringUtils.isEmpty(builder.toString())) {
                        builder.insert(0, "PoolMonitor(PoolName,CorePoolSize,MaximumPoolSize,ActiveCount,QueueSize,isShutdown):[");
                        builder.append("]");
                        logger.warn(builder.toString());
                    }
                    executionCount.incrementAndGet();
                }
            }, 30L, 5L, TimeUnit.SECONDS);
        }
    }

    public static void shutDown() {
        if (start.compareAndSet(true, false) && scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
        threadNames.clear();
    }
}

