/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.common.utils;

import com.jcloud.jcq.common.utils.StringUtils;
import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemUtils {
    private static final Logger logger = LoggerFactory.getLogger(SystemUtils.class);

    private SystemUtils() {
    }

    public static double getCPURatio() {
        return 0.0;
    }

    public static double getDiskReadRate(int unit) {
        return 0.0;
    }

    public static double getDiskWriteRate(int unit) {
        return 0.0;
    }

    public static double getNetworkInput(int unit) {
        return 0.0;
    }

    public static double getNetworkOutput(int unit) {
        return 0.0;
    }

    public static double getDiskSpaceUsedPercent(String path) {
        long totalSpace;
        if (StringUtils.isEmpty(path)) {
            logger.warn("path is empty");
            return -1.0;
        }
        File file = new File(path);
        if (!file.exists()) {
            File parent = file.getParentFile();
            if (parent == null || !parent.exists()) {
                logger.warn("file not exist for path:{} and its' parent path", (Object)path);
                return -1.0;
            }
            file = parent;
        }
        if ((totalSpace = file.getTotalSpace()) == 0L) {
            logger.warn("total space of path:{} is 0", (Object)file.getAbsolutePath());
            return -1.0;
        }
        long usedSpace = totalSpace - file.getFreeSpace();
        double usedPercent = (double)usedSpace / (double)totalSpace;
        if (logger.isDebugEnabled()) {
            logger.debug("totalSpace:{}B, usedSpace:{}B, usedPercent:{} for path:{}", new Object[]{totalSpace, usedSpace, usedPercent, file.getAbsolutePath()});
        }
        return usedPercent;
    }

    public static String getLocalIpAddress() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isMulticastAddress()) continue;
                    return inetAddress.getHostAddress();
                }
            }
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            logger.warn("Fail to get local IP address.", (Throwable)e);
            return "";
        }
    }
}

