/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.common.utils;

import com.jcloud.jcq.common.thread.SafeScheduledThreadPoolExecutor;
import com.jcloud.jcq.common.thread.ThreadFactoryImpl;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class SystemClock {
    private final AtomicLong now = new AtomicLong(-1L);
    SafeScheduledThreadPoolExecutor threadPool;

    private SystemClock() {
        this.now.set(System.currentTimeMillis());
        this.threadPool = new SafeScheduledThreadPoolExecutor(1, new ThreadFactoryImpl(SystemClock.class.getSimpleName()));
        this.threadPool.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                SystemClock.this.now.set(System.currentTimeMillis());
            }
        }, 1L, 1L, TimeUnit.MILLISECONDS);
    }

    private long nowMilliSecond() {
        return this.now.get();
    }

    public static SystemClock getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public static long now() {
        return SingletonHolder.INSTANCE.nowMilliSecond();
    }

    private static class SingletonHolder {
        private static final SystemClock INSTANCE = new SystemClock();

        private SingletonHolder() {
        }
    }
}

