/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.common.utils;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StringBuilderWrapper {
    private StringBuilder stringBuilder = new StringBuilder();
    private int age;
    private static final int CAPACITY_THRESHOLD = 4096;
    private static final int AGE_THRESHOLD = 32;
    private static final int MAX_CAPACITY = 8192;

    public void resize() {
        if (this.stringBuilder.capacity() >= 8192 || this.age >= 32) {
            this.age = 0;
            this.stringBuilder = new StringBuilder();
        }
        if (this.stringBuilder.capacity() > 4096 && this.stringBuilder.length() < 4096) {
            ++this.age;
        }
        if (this.stringBuilder.capacity() > 4096 && this.stringBuilder.length() > 4096) {
            this.age = 0;
        }
        this.stringBuilder.setLength(0);
    }

    public StringBuilderWrapper append(Object obj) {
        this.stringBuilder.append(obj);
        return this;
    }

    public StringBuilderWrapper append(List<String> strs) {
        if (strs == null || strs.isEmpty()) {
            this.stringBuilder.append("[");
            this.stringBuilder.append("]");
            return this;
        }
        this.stringBuilder.append("[");
        int len = strs.size();
        for (int i = 0; i < len; ++i) {
            this.stringBuilder.append(strs.get(i));
            if (i >= len - 1) continue;
            this.stringBuilder.append(",");
        }
        this.stringBuilder.append("]");
        return this;
    }

    public StringBuilderWrapper append(String str) {
        this.stringBuilder.append(str);
        return this;
    }

    public StringBuilderWrapper append(Map<Object, Object> maps) {
        if (maps == null || maps.isEmpty()) {
            this.stringBuilder.append("{");
            this.stringBuilder.append("}");
            return this;
        }
        Iterator<Map.Entry<Object, Object>> i = maps.entrySet().iterator();
        this.stringBuilder.append('{');
        while (i.hasNext()) {
            Map.Entry<Object, Object> e = i.next();
            Object key = e.getKey();
            Object value = e.getValue();
            this.stringBuilder.append(key == this ? "(this Map)" : key);
            this.stringBuilder.append('=');
            this.stringBuilder.append(value == this ? "(this Map)" : value);
            if (!i.hasNext()) {
                this.stringBuilder.append('}');
                break;
            }
            this.stringBuilder.append(',').append(' ');
        }
        return this;
    }

    public StringBuilderWrapper append(CharSequence s) {
        this.stringBuilder.append(s);
        return this;
    }

    public String toString() {
        String resultStr = this.stringBuilder.toString();
        this.resize();
        return resultStr;
    }

    public StringBuilder getStringBuilder() {
        return this.stringBuilder;
    }

    public void setStringBuilder(StringBuilder stringBuilder) {
        this.stringBuilder = stringBuilder;
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }
}

