/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.common.utils;

import com.jcloud.jcq.common.utils.StringUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketAddressUtil {
    private static final Logger logger = LoggerFactory.getLogger(SocketAddressUtil.class);
    private static final String COLON_MARK = ":";

    private SocketAddressUtil() {
    }

    public static String socketAddressToString(InetSocketAddress socketAddress) {
        if (socketAddress == null) {
            return null;
        }
        return socketAddress.getAddress().getHostAddress() + COLON_MARK + socketAddress.getPort();
    }

    public static InetSocketAddress stringToSocketAddress(String socketAddress) {
        if (StringUtils.isEmpty(socketAddress)) {
            return null;
        }
        int index = socketAddress.lastIndexOf(COLON_MARK);
        if (index < 0 || index == socketAddress.length() - 1) {
            return null;
        }
        try {
            String address = socketAddress.substring(0, index);
            String port = socketAddress.substring(index + 1);
            InetAddress inetAddress = InetAddress.getByName(address);
            return new InetSocketAddress(inetAddress, Integer.parseInt(port));
        }
        catch (NumberFormatException | UnknownHostException ex) {
            logger.info("String to SocketAddress exception,socketAddress is {}", (Object)socketAddress, (Object)ex);
            return null;
        }
    }
}

