/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.common.utils;

import com.jcloud.jcq.common.utils.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskUsageCheckUtils {
    private static final Logger logger = LoggerFactory.getLogger(DiskUsageCheckUtils.class);
    private static double lastAlarmPercent;
    private static double defaultThresholdPercent;
    private static double defaultAlarmFrequency;
    private static String defaultFilePath;

    public static void checkDiskUsage(String fileName, double threshold, double alarmFrequency) {
        double diskSpaceUsedPercent = SystemUtils.getDiskSpaceUsedPercent(fileName);
        lastAlarmPercent = Math.min(lastAlarmPercent, diskSpaceUsedPercent);
        if (diskSpaceUsedPercent > threshold && diskSpaceUsedPercent - lastAlarmPercent > alarmFrequency) {
            logger.error("disk used percent is {} for path:{}, more than defined threshold:{}", new Object[]{diskSpaceUsedPercent, fileName, threshold});
            lastAlarmPercent = diskSpaceUsedPercent;
        }
    }

    public static void checkDiskUsage() {
        DiskUsageCheckUtils.checkDiskUsage(defaultFilePath, defaultThresholdPercent, defaultAlarmFrequency);
    }

    public static double getDiskSpaceUsedPercent(String fileName) {
        return SystemUtils.getDiskSpaceUsedPercent(fileName);
    }

    public static double getDiskSpaceUsedPercent() {
        return SystemUtils.getDiskSpaceUsedPercent(defaultFilePath);
    }

    static {
        defaultThresholdPercent = 0.8f;
        defaultAlarmFrequency = 0.01f;
        defaultFilePath = "/export/mnt";
    }
}

