/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.common.utils;

import com.jcloud.jcq.common.utils.StringUtils;
import io.netty.channel.Channel;
import io.netty.channel.epoll.Epoll;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class CommunicationUtils {
    public static String formatChannelAddress(String addr) {
        if (!StringUtils.isEmpty(addr)) {
            int index = addr.lastIndexOf("/");
            if (index >= 0) {
                return addr.substring(index + 1);
            }
            return addr;
        }
        return "";
    }

    public static String parseChannelRemoteAddr(Channel channel) {
        if (null == channel) {
            return "";
        }
        SocketAddress remote = channel.remoteAddress();
        String addr = remote != null ? remote.toString() : "";
        return CommunicationUtils.formatChannelAddress(addr);
    }

    public static String parseChannelLocalAddr(Channel channel) {
        if (null == channel) {
            return "";
        }
        SocketAddress local = channel.localAddress();
        String addr = local != null ? local.toString() : "";
        return CommunicationUtils.formatChannelAddress(addr);
    }

    public static String parseSocketAddressAddr(SocketAddress socketAddress) {
        String addr;
        if (socketAddress != null && !StringUtils.isEmpty(addr = socketAddress.toString())) {
            return addr.substring(1);
        }
        return "";
    }

    public static String parseChannelAddress(Channel channel) {
        return String.format("localAddress: %s, remoteAddress: %s", CommunicationUtils.parseChannelLocalAddr(channel), CommunicationUtils.parseChannelRemoteAddr(channel));
    }

    public static SocketAddress string2SocketAddress(String addr) {
        String[] s = addr.split(":");
        InetSocketAddress isa = s.length > 2 ? new InetSocketAddress(addr.substring(0, addr.lastIndexOf(":")), Integer.parseInt(s[s.length - 1])) : (s.length == 2 ? new InetSocketAddress(s[0], Integer.parseInt(s[1])) : new InetSocketAddress(s[0], 80));
        return isa;
    }

    public static boolean isEpollAvailable() {
        boolean rs = false;
        boolean isLinux = System.getProperty("os.name") != null && System.getProperty("os.name").toLowerCase().contains("linux");
        rs = isLinux && Epoll.isAvailable();
        return rs;
    }
}

