/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.common.trace;

import com.jcloud.jcq.common.trace.TracePoint;
import com.jcloud.jcq.common.trace.TraceType;
import com.jcloud.jcq.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceStringHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)TraceStringHelper.class.getName());

    public static String getTraceStringFromTracePoint(TracePoint tracePoint) {
        if (tracePoint == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        switch (tracePoint.getTraceType()) {
            case PRODUCE: {
                stringBuilder.append(TraceType.PRODUCE.getCode()).append(",").append(tracePoint.getMessageId()).append(",").append(tracePoint.getBusinessId()).append(",").append(tracePoint.getClientAddress()).append(",").append(tracePoint.getRequestId()).append(",").append(tracePoint.getTopic()).append(",").append(tracePoint.getQueueId()).append(",").append(tracePoint.isSuccess()).append(",").append(tracePoint.getTimeStamp()).append(",").append(tracePoint.getCostTime()).append(",").append(tracePoint.getDelayTime()).append(",").append(tracePoint.getVersion().getCode());
                break;
            }
            case BEFORE_CONSUME: {
                stringBuilder.append(TraceType.BEFORE_CONSUME.getCode()).append(",").append(tracePoint.getMessageId()).append(",").append(tracePoint.getBusinessId()).append(",").append(tracePoint.getClientAddress()).append(",").append(tracePoint.getRequestId()).append(",").append(tracePoint.getTenantId()).append(",").append(tracePoint.getConsumerGroupId()).append(",").append(tracePoint.getRetryTimes()).append(",").append(tracePoint.getTimeStamp()).append(",").append(tracePoint.getVersion().getCode());
                break;
            }
            case AFTER_CONSUME: {
                stringBuilder.append(TraceType.AFTER_CONSUME.getCode()).append(",").append(tracePoint.getMessageId()).append(",").append(tracePoint.getBusinessId()).append(",").append(tracePoint.getClientAddress()).append(",").append(tracePoint.getRequestId()).append(",").append(tracePoint.isSuccess()).append(",").append(tracePoint.getTenantId()).append(",").append(tracePoint.getConsumerGroupId()).append(",").append(tracePoint.getRetryTimes()).append(",").append(tracePoint.getCostTime()).append(",").append(tracePoint.getVersion().getCode());
            }
        }
        return stringBuilder.toString();
    }

    public static TracePoint getTracePointFromTraceString(String traceString) {
        if (StringUtils.isEmpty(traceString)) {
            return null;
        }
        String[] segments = traceString.split(",", -1);
        if (segments.length < 1) {
            return null;
        }
        TracePoint tracePoint = new TracePoint();
        int len = segments.length;
        if (segments[0].equals(String.valueOf(TraceType.PRODUCE.getCode()))) {
            if (len < 12) {
                return null;
            }
            if (len > 12) {
                logger.warn("Unexpected trace string: {}, segments length: {}, maybe businessId contains TAG_SEPARATOR_REG.", (Object)traceString, (Object)len);
            }
            tracePoint.setTraceType(TraceType.PRODUCE);
            tracePoint.setClientAddress(segments[len - 9]);
            tracePoint.setRequestId(segments[len - 8]);
            tracePoint.setTopic(segments[len - 7]);
            tracePoint.setQueueId(Integer.parseInt(segments[len - 6]));
            tracePoint.setSuccess(Boolean.parseBoolean(segments[len - 5]));
            tracePoint.setTimeStamp(Long.parseLong(segments[len - 4]));
            tracePoint.setCostTime(Integer.parseInt(segments[len - 3]));
            tracePoint.setDelayTime(Integer.parseInt(segments[len - 2]));
        } else if (segments[0].equals(String.valueOf(TraceType.BEFORE_CONSUME.getCode()))) {
            if (len < 10) {
                return null;
            }
            if (len > 10) {
                logger.warn("Unexpected trace string: {}, segments length: {}, maybe businessId contains TAG_SEPARATOR_REG.", (Object)traceString, (Object)len);
            }
            tracePoint.setTraceType(TraceType.BEFORE_CONSUME);
            tracePoint.setClientAddress(segments[len - 7]);
            tracePoint.setRequestId(segments[len - 6]);
            tracePoint.setTenantId(segments[len - 5]);
            tracePoint.setConsumerGroupId(segments[len - 4]);
            tracePoint.setRetryTimes(Integer.parseInt(segments[len - 3]));
            tracePoint.setTimeStamp(Long.parseLong(segments[len - 2]));
        } else if (segments[0].equals(String.valueOf(TraceType.AFTER_CONSUME.getCode()))) {
            if (segments.length < 11) {
                return null;
            }
            if (segments.length > 11) {
                logger.warn("Unexpected trace string: {}, segments length: {}, maybe businessId contains TAG_SEPARATOR_REG.", (Object)traceString, (Object)len);
            }
            tracePoint.setTraceType(TraceType.AFTER_CONSUME);
            tracePoint.setClientAddress(segments[len - 8]);
            tracePoint.setRequestId(segments[len - 7]);
            tracePoint.setSuccess(Boolean.parseBoolean(segments[len - 6]));
            tracePoint.setTenantId(segments[len - 5]);
            tracePoint.setConsumerGroupId(segments[len - 4]);
            tracePoint.setRetryTimes(Integer.parseInt(segments[len - 3]));
            tracePoint.setCostTime(Integer.parseInt(segments[len - 2]));
        } else {
            return null;
        }
        tracePoint.setMessageId(segments[1]);
        int messageIdIndex = traceString.indexOf(tracePoint.getMessageId());
        int addressIndex = traceString.indexOf(tracePoint.getClientAddress());
        tracePoint.setBusinessId(traceString.substring(messageIdIndex + segments[1].length() + 1, addressIndex - 1));
        return tracePoint;
    }
}

