/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.common.topic;

public enum TopicPermission {
    SUB(1),
    PUB(2),
    PUBSUB(3),
    FORBIDDEN(4),
    ADMIN(5);

    int code;

    private TopicPermission(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static TopicPermission valueOf(int code) {
        switch (code) {
            case 1: {
                return SUB;
            }
            case 2: {
                return PUB;
            }
            case 3: {
                return PUBSUB;
            }
            case 4: {
                return FORBIDDEN;
            }
            case 5: {
                return ADMIN;
            }
        }
        return null;
    }

    public boolean isReadable() {
        return this.code == 1 || this.code == 3 || this.code == 5;
    }

    public boolean isWriteable() {
        return this.code == 2 || this.code == 3 || this.code == 5;
    }
}

