/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.common.topic;

import com.jcloud.jcq.common.Validator;
import com.jcloud.jcq.common.topic.TopicPermission;
import com.jcloud.jcq.common.topic.TopicType;
import com.jcloud.jcq.common.utils.StringUtils;
import java.util.HashMap;

public class TopicConfig
implements Validator {
    private static final int MINIMUM_TOPIC_TPS = 200;
    private String topicName;
    private int queueNumbers;
    private TopicPermission topicPermission;
    private TopicType topicType;
    private String userId;
    private int threshold;
    private int maxMessageSize;
    private String topicId;

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public int getQueueNumbers() {
        return this.queueNumbers;
    }

    public void setQueueNumbers(int queueNumbers) {
        this.queueNumbers = queueNumbers;
    }

    public TopicPermission getTopicPermission() {
        return this.topicPermission;
    }

    public boolean canProduce() {
        return this.topicPermission != TopicPermission.FORBIDDEN && this.topicPermission != TopicPermission.SUB;
    }

    public boolean canConsume() {
        return this.topicPermission != TopicPermission.FORBIDDEN && this.topicPermission != TopicPermission.PUB;
    }

    public void setTopicPermission(TopicPermission topicPermission) {
        this.topicPermission = topicPermission;
    }

    public TopicType getTopicType() {
        return this.topicType;
    }

    public void setTopicType(TopicType topicType) {
        this.topicType = topicType;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public String getTopicId() {
        return this.topicId;
    }

    public void setTopicId(String topicId) {
        this.topicId = topicId;
    }

    public String toString() {
        HashMap<String, String> kv = new HashMap<String, String>(8);
        kv.put("topicName", this.topicName);
        kv.put("queueNumbers", String.valueOf(this.queueNumbers));
        kv.put("topicPermission", this.topicPermission.toString());
        kv.put("topicType", this.topicType.toString());
        kv.put("userId", this.userId);
        kv.put("maxMessageSize", String.valueOf(this.maxMessageSize));
        kv.put("topicId", this.topicId);
        kv.put("threshold", String.valueOf(this.threshold));
        return StringUtils.toStringHelper("TopicConfig", kv);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicConfig config = (TopicConfig)o;
        return this.topicName.equals(config.getTopicName()) && this.userId.equals(config.getUserId()) && this.queueNumbers == config.queueNumbers && this.topicType == config.topicType && this.maxMessageSize == config.maxMessageSize && this.topicId.equals(config.topicId);
    }

    public int hashCode() {
        int result = this.topicName != null ? this.topicName.hashCode() : 0;
        result = 31 * result + (this.userId != null ? this.userId.hashCode() : 0);
        result = 31 * result + this.queueNumbers;
        result = 31 * result + this.topicType.ordinal();
        result = 31 * result + this.maxMessageSize;
        result = 31 * result + (this.topicId != null ? this.topicId.hashCode() : 0);
        return result;
    }

    @Override
    public boolean validate() {
        return !StringUtils.isEmpty(this.topicName) && !StringUtils.isEmpty(this.topicName) && this.queueNumbers > 0 && !StringUtils.isEmpty(this.userId) && this.threshold >= 200 && this.maxMessageSize > 0 && !StringUtils.isEmpty(this.topicId);
    }
}

