/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.common.thread;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private static final Logger logger = LoggerFactory.getLogger((String)"ScheduledThreadPoolExecutor");

    public SafeScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return super.scheduleAtFixedRate(new SafeScheduledRunnable(command), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return super.scheduleWithFixedDelay(new SafeScheduledRunnable(command), initialDelay, delay, unit);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return super.schedule(new SafeScheduledRunnable(command), delay, unit);
    }

    static class SafeScheduledRunnable
    implements Runnable {
        private final Runnable runnable;

        SafeScheduledRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Exception e) {
                logger.error("Scheduled Runnable got exception: ", (Throwable)e);
            }
        }
    }
}

