/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.common.partition;

import com.jcloud.jcq.common.topic.TopicPermission;

public enum PartitionPermission {
    READ(1),
    WRITE(2),
    READ_WRITE(3),
    NONE(0);

    private int code;

    private PartitionPermission(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static PartitionPermission parse(String permission) {
        switch (permission) {
            case "PUBSUB": {
                return READ_WRITE;
            }
            case "PUB": {
                return WRITE;
            }
            case "SUB": {
                return READ;
            }
        }
        return NONE;
    }

    public static TopicPermission toTopicPermission(PartitionPermission partitionPermission) {
        if (partitionPermission == null) {
            return TopicPermission.FORBIDDEN;
        }
        switch (partitionPermission) {
            case READ_WRITE: {
                return TopicPermission.PUBSUB;
            }
            case WRITE: {
                return TopicPermission.PUB;
            }
            case READ: {
                return TopicPermission.SUB;
            }
        }
        return TopicPermission.FORBIDDEN;
    }

    public static PartitionPermission convert(TopicPermission topicPermission) {
        if (topicPermission == null) {
            return NONE;
        }
        switch (topicPermission) {
            case PUBSUB: {
                return READ_WRITE;
            }
            case PUB: {
                return WRITE;
            }
            case SUB: {
                return READ;
            }
        }
        return NONE;
    }

    public static PartitionPermission join(PartitionPermission partitionPermission, TopicPermission topicPermission) {
        if (partitionPermission == null || topicPermission == null) {
            return NONE;
        }
        switch (partitionPermission) {
            case READ: {
                if (topicPermission != TopicPermission.PUBSUB && topicPermission != TopicPermission.SUB) {
                    return NONE;
                }
                return READ;
            }
            case WRITE: {
                if (topicPermission != TopicPermission.PUBSUB && topicPermission != TopicPermission.PUB) {
                    return NONE;
                }
                return WRITE;
            }
            case READ_WRITE: {
                if (topicPermission == TopicPermission.PUB) {
                    return WRITE;
                }
                if (topicPermission == TopicPermission.SUB) {
                    return READ;
                }
                if (topicPermission == TopicPermission.FORBIDDEN) {
                    return NONE;
                }
                return READ_WRITE;
            }
        }
        return NONE;
    }

    public boolean isReadable() {
        return this.code == PartitionPermission.READ.code || this.code == PartitionPermission.READ_WRITE.code;
    }

    public boolean isWriteable() {
        return this.code == PartitionPermission.WRITE.code || this.code == PartitionPermission.READ_WRITE.code;
    }
}

