/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.common.filter;

import com.jcloud.jcq.common.filter.MessageFilter;
import com.jcloud.jcq.common.utils.HashUtil;
import com.jcloud.jcq.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class TagFilter
implements MessageFilter {
    private List<Integer> tagCodes = new ArrayList<Integer>();
    private String expression;

    public TagFilter(String expression) {
        this.expression = expression;
        if (!StringUtils.isEmpty(expression)) {
            String[] splits;
            for (String split : splits = expression.split(",")) {
                this.tagCodes.add(HashUtil.codeFromString(split.trim()));
            }
        }
    }

    @Override
    public boolean fitFor(String tags) {
        if (this.tagCodes.isEmpty()) {
            return true;
        }
        if (StringUtils.isEmpty(tags)) {
            return false;
        }
        String[] splits = tags.split(",");
        if (splits.length == 0) {
            return false;
        }
        for (String tag : splits) {
            if (-1 == this.tagCodes.indexOf(HashUtil.codeFromString(tag.trim()))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "TagFilter{expression='" + this.expression + '\'' + '}';
    }
}

