/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.common.cache;

import com.google.common.cache.CacheLoader;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.jcloud.jcq.common.cache.CacheValueValidator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JCQCacheLoader<K, V>
extends CacheLoader<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(JCQCacheLoader.class);
    private final ExecutorService executorService;
    private final CacheValueValidator<V> validator;

    public JCQCacheLoader(ExecutorService executorService, CacheValueValidator<V> validator) {
        this.executorService = executorService;
        this.validator = validator;
    }

    public V load(K key) throws Exception {
        return this.action(key);
    }

    public ListenableFuture<V> reload(final K key, final V oldValue) throws Exception {
        logger.info("get value for key: {}, oldValue:{}", key, oldValue);
        ListenableFutureTask futureTask = ListenableFutureTask.create((Callable)new Callable<V>(){

            @Override
            public V call() throws Exception {
                try {
                    Object newValue = JCQCacheLoader.this.action(key);
                    if (newValue != null && JCQCacheLoader.this.validator.validate(newValue)) {
                        return newValue;
                    }
                    return oldValue;
                }
                catch (Exception e) {
                    logger.warn("get value by key {} failed, will use oldValue {}", key, oldValue);
                    return oldValue;
                }
            }
        });
        this.executorService.execute((Runnable)futureTask);
        return futureTask;
    }

    protected abstract V action(K var1) throws Exception;
}

