/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.common.broker;

import com.jcloud.jcq.common.Validator;
import com.jcloud.jcq.common.utils.StringUtils;
import java.util.Objects;

public class Broker
implements Validator {
    private String brokerGroupId;
    private String brokerId;
    private String address;
    private String externalAddress;
    private String availableZone;
    private int tpsUpperLimit;

    public Broker() {
    }

    public Broker(String brokerGroupId, String brokerId, String address, String availableZone, int tpsUpperLimit) {
        this.brokerGroupId = brokerGroupId;
        this.brokerId = brokerId;
        this.address = address;
        this.availableZone = availableZone;
        this.tpsUpperLimit = tpsUpperLimit;
    }

    public Broker(String brokerGroupId, String brokerId, String address, String externalAddress) {
        this.brokerGroupId = brokerGroupId;
        this.brokerId = brokerId;
        this.address = address;
        this.externalAddress = externalAddress;
    }

    public String getBrokerGroupId() {
        return this.brokerGroupId;
    }

    public void setBrokerGroupId(String brokerGroupId) {
        this.brokerGroupId = brokerGroupId;
    }

    public String getBrokerId() {
        return this.brokerId;
    }

    public void setBrokerId(String brokerId) {
        this.brokerId = brokerId;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getExternalAddress() {
        return this.externalAddress;
    }

    public void setExternalAddress(String externalAddress) {
        this.externalAddress = externalAddress;
    }

    public String getAvailableZone() {
        return this.availableZone;
    }

    public void setAvailableZone(String availableZone) {
        this.availableZone = availableZone;
    }

    public int getTpsUpperLimit() {
        return this.tpsUpperLimit;
    }

    public void setTpsUpperLimit(int tpsUpperLimit) {
        this.tpsUpperLimit = tpsUpperLimit;
    }

    @Override
    public boolean validate() {
        return !StringUtils.isEmpty(this.brokerGroupId) && !StringUtils.isEmpty(this.brokerId) && !StringUtils.isEmpty(this.address) && !StringUtils.isEmpty(this.externalAddress) && !StringUtils.isEmpty(this.availableZone) && this.tpsUpperLimit > 0;
    }

    public String toString() {
        return "Broker{brokerGroupId='" + this.brokerGroupId + '\'' + ",brokerId='" + this.brokerId + '\'' + ",address='" + this.address + '\'' + ",externalAddress='" + this.externalAddress + '\'' + ",availableZone='" + this.availableZone + '\'' + ",tpsUpperLimit=" + this.tpsUpperLimit + '}';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Broker broker = (Broker)obj;
        return Objects.equals(this.brokerGroupId, broker.getBrokerGroupId()) && Objects.equals(this.brokerId, broker.getBrokerId()) && Objects.equals(this.address, broker.getAddress()) && Objects.equals(this.externalAddress, broker.getExternalAddress()) && Objects.equals(this.availableZone, broker.getAvailableZone()) && this.tpsUpperLimit == broker.getTpsUpperLimit();
    }

    public int hashCode() {
        int result = this.brokerGroupId == null ? 0 : this.brokerGroupId.hashCode();
        result = 31 * result + (this.brokerId == null ? 0 : this.brokerId.hashCode());
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.externalAddress == null ? 0 : this.externalAddress.hashCode());
        result = 31 * result + (this.availableZone == null ? 0 : this.availableZone.hashCode());
        result = 31 * result + this.tpsUpperLimit;
        return result;
    }
}

