/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.client.consumer;

import com.jcloud.jcq.client.Exception.ClientException;
import com.jcloud.jcq.client.Exception.ClientExceptionCode;
import com.jcloud.jcq.client.consumer.Consumer;
import com.jcloud.jcq.client.consumer.ConsumerConfig;
import com.jcloud.jcq.client.consumer.PullConsumer;
import com.jcloud.jcq.client.consumer.SubscribeConsumer;
import com.jcloud.jcq.client.consumer.impl.DefaultPullConsumerImpl;
import com.jcloud.jcq.client.consumer.impl.DefaultSubscribeConsumerImpl;
import com.jcloud.jcq.common.utils.StringUtils;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerFactory {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerFactory.class);
    public static final ConsumerFactory instance = new ConsumerFactory();
    private ConcurrentMap<String, Consumer> consumers = new ConcurrentHashMap<String, Consumer>();

    private ConsumerFactory() {
    }

    public static ConsumerFactory getInstance() {
        return instance;
    }

    public SubscribeConsumer createSubscribeConsumer(String accessKey, String secretKey, String consumerGroupId) throws ClientException {
        ConsumerConfig consumerConfig = new ConsumerConfig();
        consumerConfig.setConsumerGroupId(consumerGroupId);
        return this.createSubscribeConsumer(accessKey, secretKey, consumerConfig);
    }

    public synchronized SubscribeConsumer createSubscribeConsumer(String accessKey, String secretKey, ConsumerConfig consumerConfig) throws ClientException {
        this.validateParameters(accessKey, secretKey, consumerConfig);
        String consumerId = this.getConsumerId(accessKey.trim(), consumerConfig);
        Consumer consumer = (Consumer)this.consumers.get(consumerId);
        if (consumer == null) {
            consumer = new DefaultSubscribeConsumerImpl(accessKey.trim(), secretKey.trim(), consumerId, consumerConfig);
            this.consumers.put(consumerId, consumer);
            logger.debug("Consumer {} is created with parameters:{}", (Object)consumerId, (Object)consumerConfig);
        } else if (!(consumer instanceof SubscribeConsumer)) {
            String msg = String.format("consumerId [%s] is occupied by a consumer with different consume type", consumerId);
            logger.warn(msg);
            throw new ClientException(msg);
        }
        return (SubscribeConsumer)consumer;
    }

    public PullConsumer createPullConsumer(String accessKey, String secretKey, String consumerGroupId) throws ClientException {
        ConsumerConfig consumerConfig = new ConsumerConfig();
        consumerConfig.setConsumerGroupId(consumerGroupId);
        return this.createPullConsumer(accessKey, secretKey, consumerConfig);
    }

    public synchronized PullConsumer createPullConsumer(String accessKey, String secretKey, ConsumerConfig consumerConfig) throws ClientException {
        this.validateParameters(accessKey, secretKey, consumerConfig);
        String consumerId = this.getConsumerId(accessKey.trim(), consumerConfig);
        Consumer consumer = (Consumer)this.consumers.get(consumerId);
        if (consumer == null) {
            consumer = new DefaultPullConsumerImpl(accessKey.trim(), secretKey.trim(), consumerId, consumerConfig);
            this.consumers.put(consumerId, consumer);
            logger.debug("Consumer {} is created with parameters:{}", (Object)consumerId, (Object)consumerConfig);
        } else if (!(consumer instanceof PullConsumer)) {
            String msg = String.format("consumerId [%s] is occupied by a consumer with different consume type", consumerId);
            logger.warn(msg);
            throw new ClientException(msg);
        }
        return (PullConsumer)consumer;
    }

    private String getConsumerId(String accessKey, ConsumerConfig consumerConfig) throws ClientException {
        return accessKey.hashCode() + "@" + consumerConfig.getConsumerGroupId() + "@" + UUID.randomUUID().toString();
    }

    private void validateParameters(String accessKey, String secretKey, ConsumerConfig consumerConfig) throws ClientException {
        if (StringUtils.isEmpty(accessKey) || StringUtils.isEmpty(accessKey.trim())) {
            throw new ClientException("accessKey is empty.", ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
        if (StringUtils.isEmpty(secretKey) || StringUtils.isEmpty(secretKey.trim())) {
            throw new ClientException("secretKey is empty.", ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
        if (consumerConfig == null) {
            throw new ClientException("consumerConfig is null.", ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
        consumerConfig.validate();
    }
}

