/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.client.common.impl;

import com.jcloud.jcq.client.common.QueueSelectStrategy;
import com.jcloud.jcq.common.queue.QueueRouteInfo;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RoundRobinQueueSelectStrategy
implements QueueSelectStrategy {
    public static final String STRATEGY_NAME = "RoundRobin";
    private ConcurrentMap<String, QueueRouteInfo> topicCurrentQueueMap = new ConcurrentHashMap<String, QueueRouteInfo>();

    @Override
    public QueueRouteInfo selectQueue(String topic, List<QueueRouteInfo> queueRouteInfos) {
        if (queueRouteInfos == null || queueRouteInfos.isEmpty()) {
            return null;
        }
        QueueRouteInfo selectedQueue = queueRouteInfos.get(0);
        QueueRouteInfo currentQueue = (QueueRouteInfo)this.topicCurrentQueueMap.get(topic);
        int currentQueueIndex = queueRouteInfos.indexOf(currentQueue);
        if (currentQueueIndex >= 0) {
            selectedQueue = queueRouteInfos.get((currentQueueIndex + 1) % queueRouteInfos.size());
        }
        this.topicCurrentQueueMap.put(topic, selectedQueue);
        return selectedQueue;
    }
}

