/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.client.common;

import com.jcloud.jcq.client.Exception.ClientException;
import com.jcloud.jcq.client.Exception.ClientExceptionCode;
import com.jcloud.jcq.common.client.ClientType;
import com.jcloud.jcq.common.utils.StringUtils;
import com.jcloud.jcq.common.version.JcqVersion;

public class ClientConfig {
    protected ClientType clientType = ClientType.JAVA;
    public static final JcqVersion CLIENT_VERSION = JcqVersion.V2_0_1;
    protected String metaServerAddress = System.getProperty("meta.server.addr", System.getenv("meta.server.addr"));
    protected int maxRetryTimes = 2;
    private boolean messageTraceOn = false;
    private boolean forTrace = false;
    protected int sendTimeout = 0;
    protected int refreshRouteInterval = 60;
    protected String token;
    protected int remoteCallRetryWaitTime = 100;
    protected int refreshRouteRetryWaitTime = 200;

    public int getRemoteCallRetryWaitTime() {
        return this.remoteCallRetryWaitTime;
    }

    public void setRemoteCallRetryWaitTime(int remoteCallRetryWaitTime) {
        this.remoteCallRetryWaitTime = remoteCallRetryWaitTime;
    }

    public int getRefreshRouteRetryWaitTime() {
        return this.refreshRouteRetryWaitTime;
    }

    public void setRefreshRouteRetryWaitTime(int refreshRouteRetryWaitTime) {
        this.refreshRouteRetryWaitTime = refreshRouteRetryWaitTime;
    }

    public ClientType getClientType() {
        return this.clientType;
    }

    public void setClientType(ClientType clientType) {
        this.clientType = clientType;
    }

    public String getMetaServerAddress() {
        return this.metaServerAddress;
    }

    public void setMetaServerAddress(String metaServerAddress) {
        this.metaServerAddress = metaServerAddress;
    }

    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    public boolean isMessageTraceOn() {
        return this.messageTraceOn;
    }

    public void setMessageTraceOn(boolean messageTraceOn) {
        this.messageTraceOn = messageTraceOn;
    }

    public boolean isForTrace() {
        return this.forTrace;
    }

    public void setForTrace(boolean forTrace) {
        this.forTrace = forTrace;
    }

    public int getSendTimeout() {
        return this.sendTimeout;
    }

    public void setSendTimeout(int sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public int getRefreshRouteInterval() {
        return this.refreshRouteInterval;
    }

    public void setRefreshRouteInterval(int refreshRouteInterval) {
        this.refreshRouteInterval = refreshRouteInterval;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void validate() throws ClientException {
        if (this.clientType == null) {
            throw new ClientException("clientType is null", ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
        if (StringUtils.isEmpty(this.metaServerAddress)) {
            throw new ClientException("metaServerAddress is empty", ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
        if (this.maxRetryTimes < 0) {
            throw new ClientException(String.format("maxRetryTimes:%d is invalid", this.maxRetryTimes), ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
        if (this.refreshRouteInterval <= 0) {
            throw new ClientException(String.format("refreshRouteInterval:%d is invalid", this.refreshRouteInterval), ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
    }
}

